/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.io.LineReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.io.Cleanly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Preferences {
    private static final Pattern PREFERENCE_PATTERN = Pattern.compile("user_pref\\(\"([^\"]+)\", (\"?.+?\"?)\\);");
    private Map<String, Object> allPrefs = Maps.newHashMap();

    public Preferences() {
    }

    public Preferences(File userPrefs) {
        FileReader reader = null;
        try {
            reader = new FileReader(userPrefs);
            this.readPreferences(reader);
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                Cleanly.close(reader);
                throw throwable;
            }
        }
        Cleanly.close((Reader)reader);
    }

    public Preferences(Reader reader) {
        try {
            this.readPreferences(reader);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            Cleanly.close((Reader)reader);
        }
    }

    private void readPreferences(Reader reader) throws IOException {
        LineReader allLines = new LineReader((Readable)reader);
        String line = allLines.readLine();
        while (line != null) {
            Matcher matcher = PREFERENCE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.allPrefs.put(matcher.group(1), this.preferenceAsValue(matcher.group(2)));
            }
            line = allLines.readLine();
        }
    }

    public void setPreference(String key, String value) {
        if (this.isStringified(value)) {
            throw new IllegalArgumentException(String.format("Preference values must be plain strings: %s: %s", key, value));
        }
        this.allPrefs.put(key, value);
    }

    public void setPreference(String key, boolean value) {
        this.allPrefs.put(key, value);
    }

    public void setPreference(String key, int value) {
        this.allPrefs.put(key, value);
    }

    public void addTo(Preferences prefs) {
        prefs.allPrefs.putAll(this.allPrefs);
    }

    public void addTo(FirefoxProfile profile) {
        profile.getAdditionalPreferences().allPrefs.putAll(this.allPrefs);
    }

    public void writeTo(Writer writer) throws IOException {
        for (Map.Entry<String, Object> pref : this.allPrefs.entrySet()) {
            writer.append("user_pref(\"").append(pref.getKey()).append("\", ");
            writer.append(this.valueAsPreference(pref.getValue()));
            writer.append(");\n");
        }
    }

    private String valueAsPreference(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return String.valueOf(value);
    }

    private Object preferenceAsValue(String toConvert) {
        if (toConvert.startsWith("\"") && toConvert.endsWith("\"")) {
            return toConvert.substring(1, toConvert.length() - 1);
        }
        if ("false".equals(toConvert) || "true".equals(toConvert)) {
            return Boolean.parseBoolean(toConvert);
        }
        try {
            return Integer.parseInt(toConvert);
        }
        catch (NumberFormatException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected Object getPreference(String key) {
        return this.allPrefs.get(key);
    }

    private boolean isStringified(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    public void putAll(Map<String, Object> frozenPreferences) {
        this.allPrefs.putAll(frozenPreferences);
    }
}

