/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jdhcp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.opennms.jdhcp.DHCPMessage;

public class DHCPSocket
extends DatagramSocket {
    protected static int sPACKETSIZE = 1500;
    private static final int DEFAULT_SO_TIMEOUT = 3000;

    public DHCPSocket(int inPort) throws SocketException {
        super(inPort);
        this.setSoTimeout(3000);
    }

    public static void setMTU(int inSize) {
        sPACKETSIZE = inSize;
    }

    public static int getMTU() {
        return sPACKETSIZE;
    }

    public synchronized void send(DHCPMessage inMessage) throws IOException {
        byte[] data = inMessage.externalize();
        InetAddress dest = inMessage.getDestination();
        DatagramPacket outgoing = new DatagramPacket(data, data.length, dest, inMessage.getPort());
        this.send(outgoing);
    }

    public synchronized boolean receive(DHCPMessage outMessage) {
        try {
            DatagramPacket incoming = new DatagramPacket(new byte[sPACKETSIZE], sPACKETSIZE);
            this.receive(incoming);
            outMessage.internalize(incoming.getData());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

