/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import java.util.Enumeration;
import java.util.Hashtable;

public class DHCPOptions {
    private Hashtable optionsTable = new Hashtable();

    public void removeOption(byte by) {
        this.optionsTable.remove(new Byte(by));
    }

    public boolean contains(byte by) {
        return this.optionsTable.containsKey(new Byte(by));
    }

    public boolean isEmpty() {
        return this.optionsTable.isEmpty();
    }

    public byte[] getOption(byte by) {
        if (this.contains(by)) {
            DHCPOptionsEntry dHCPOptionsEntry = (DHCPOptionsEntry)this.optionsTable.get(new Byte(by));
            return dHCPOptionsEntry.content;
        }
        return null;
    }

    public void setOption(byte by, byte[] byArray) {
        DHCPOptionsEntry dHCPOptionsEntry = new DHCPOptionsEntry(by, (byte)byArray.length, byArray);
        this.optionsTable.put(new Byte(by), dHCPOptionsEntry);
    }

    private byte[] getArrayOption(int n, int n2, byte[] byArray) {
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            byArray2[n3] = byArray[n2 + n3];
            ++n3;
        }
        return byArray2;
    }

    public void internalize(byte[] byArray) {
        int n = 4;
        while (byArray[n] != -1) {
            byte by = byArray[n++];
            byte by2 = byArray[n++];
            byte[] byArray2 = this.getArrayOption(by2, n, byArray);
            this.setOption(by, byArray2);
            n += by2;
        }
    }

    public byte[] externalize() {
        byte[] byArray = new byte[312];
        byArray[0] = 99;
        byArray[1] = -126;
        byArray[2] = 83;
        byArray[3] = 99;
        int n = 4;
        Enumeration enumeration = this.optionsTable.elements();
        while (enumeration.hasMoreElements()) {
            DHCPOptionsEntry dHCPOptionsEntry = (DHCPOptionsEntry)enumeration.nextElement();
            byArray[n++] = dHCPOptionsEntry.code;
            byArray[n++] = dHCPOptionsEntry.length;
            int n2 = 0;
            while (n2 < dHCPOptionsEntry.length) {
                byArray[n++] = dHCPOptionsEntry.content[n2];
                ++n2;
            }
        }
        byArray[n] = -1;
        return byArray;
    }

    public void printList() {
        System.out.println(this.optionsTable.toString());
    }

    class DHCPOptionsEntry {
        protected byte code;
        protected byte length;
        protected byte[] content;

        public DHCPOptionsEntry(byte by, byte by2, byte[] byArray) {
            DHCPOptions.this = DHCPOptions.this;
            this.code = by;
            this.length = by2;
            this.content = byArray;
        }
    }
}

