/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reporting;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.reporting.Parameters;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="report")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="reporting.xsd")
public class Report
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="id", required=true)
    private String m_id;
    @XmlAttribute(name="type", required=true)
    private String m_type;
    @XmlElement(name="parameters")
    private Parameters m_parameters;
    @XmlElement(name="pdf-template")
    private String m_pdfTemplate;
    @XmlElement(name="svg-template")
    private String m_svgTemplate;
    @XmlElement(name="html-template")
    private String m_htmlTemplate;
    @XmlElement(name="logo", required=true)
    private String m_logo;

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = ConfigUtils.assertNotEmpty(id, "id");
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.assertNotEmpty(type, "type");
    }

    public Optional<Parameters> getParameters() {
        return Optional.ofNullable(this.m_parameters);
    }

    public void setParameters(Parameters parameters) {
        this.m_parameters = parameters;
    }

    public Optional<String> getPdfTemplate() {
        return Optional.ofNullable(this.m_pdfTemplate);
    }

    public void setPdfTemplate(String pdfTemplate) {
        this.m_pdfTemplate = ConfigUtils.normalizeString(pdfTemplate);
    }

    public Optional<String> getSvgTemplate() {
        return Optional.ofNullable(this.m_svgTemplate);
    }

    public void setSvgTemplate(String svgTemplate) {
        this.m_svgTemplate = ConfigUtils.normalizeString(svgTemplate);
    }

    public Optional<String> getHtmlTemplate() {
        return Optional.ofNullable(this.m_htmlTemplate);
    }

    public void setHtmlTemplate(String htmlTemplate) {
        this.m_htmlTemplate = ConfigUtils.normalizeString(htmlTemplate);
    }

    public String getLogo() {
        return this.m_logo;
    }

    public void setLogo(String logo) {
        this.m_logo = ConfigUtils.assertNotEmpty(logo, "logo");
    }

    public int hashCode() {
        return Objects.hash(this.m_id, this.m_type, this.m_parameters, this.m_pdfTemplate, this.m_svgTemplate, this.m_htmlTemplate, this.m_logo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report that = (Report)obj;
            return Objects.equals(this.m_id, that.m_id) && Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_parameters, that.m_parameters) && Objects.equals(this.m_pdfTemplate, that.m_pdfTemplate) && Objects.equals(this.m_svgTemplate, that.m_svgTemplate) && Objects.equals(this.m_htmlTemplate, that.m_htmlTemplate) && Objects.equals(this.m_logo, that.m_logo);
        }
        return false;
    }
}

