/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opennms.core.network.IPAddressRange;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpValue {
    private static final Logger LOG = LoggerFactory.getLogger(IpValue.class);
    private final List<IPAddressRange> ranges = Lists.newArrayList();

    public IpValue(String input) {
        this(new StringValue(input));
    }

    public IpValue(StringValue input) {
        Objects.requireNonNull(input);
        this.parse(input);
    }

    private void parse(StringValue input) {
        if (input.isNullOrEmpty()) {
            throw new IllegalArgumentException("input may not be null or empty");
        }
        List<StringValue> actualValues = input.splitBy(",");
        for (StringValue eachValue : actualValues) {
            if (eachValue.isRanged()) {
                List<StringValue> rangedValues = eachValue.splitBy("-");
                if (rangedValues.size() != 2) {
                    LOG.warn("Received multiple ranges {}. Will only use {}", rangedValues, rangedValues.subList(0, 2));
                }
                for (StringValue rangedValue : rangedValues) {
                    if (!rangedValue.contains("/")) continue;
                    throw new IllegalArgumentException("Ranged value may not contain a CIDR expression");
                }
                this.ranges.add(new IPAddressRange(rangedValues.get(0).getValue(), rangedValues.get(1).getValue()));
                continue;
            }
            if (eachValue.getValue().contains("/")) {
                this.ranges.add(IpValue.parseCIDR(eachValue.getValue()));
                continue;
            }
            this.ranges.add(new IPAddressRange(eachValue.getValue()));
        }
    }

    public boolean isInRange(String address) {
        return this.ranges.stream().anyMatch(r -> r.contains(address));
    }

    public static IPAddressRange parseCIDR(String cidr) {
        int slashIndex = cidr.indexOf(47);
        if (slashIndex == -1) {
            throw new IllegalArgumentException("Value is not a CIDR expression");
        }
        byte[] address = InetAddressUtils.toIpAddrBytes((String)cidr.substring(0, slashIndex));
        int mask = Integer.parseInt(cidr.substring(slashIndex + 1));
        byte[] lower = Arrays.copyOf(address, address.length);
        for (int i = lower.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                lower[i] = 0;
                continue;
            }
            int n = i;
            lower[n] = (byte)(lower[n] & 255 << 8 - (mask - i * 8));
        }
        byte[] upper = Arrays.copyOf(address, address.length);
        for (int i = upper.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                upper[i] = -1;
                continue;
            }
            int n = i;
            upper[n] = (byte)(upper[n] | 255 >> mask - i * 8);
        }
        return new IPAddressRange(InetAddressUtils.toIpAddrString((byte[])lower), InetAddressUtils.toIpAddrString((byte[])upper));
    }
}

