/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.VertexRef;

public final class ImmutableVertexRef
implements VertexRef {
    private final String namespace;
    private final String id;

    private ImmutableVertexRef(Builder builder) {
        this.namespace = builder.namespace;
        this.id = builder.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableVertexRef that = (ImmutableVertexRef)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.id);
    }

    public String toString() {
        return "ImmutableVertexRef{namespace='" + this.namespace + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public static Builder newBuilder(Vertex vertex) {
        Objects.requireNonNull(vertex);
        return ImmutableVertexRef.newBuilder(vertex.getNamespace(), vertex.getId());
    }

    public static Builder newBuilder(String namespace, String id) {
        return new Builder().namespace(namespace).id(id);
    }

    public static Builder newBuilderFrom(VertexRef vertexRef) {
        Objects.requireNonNull(vertexRef);
        return new Builder().namespace(vertexRef.getNamespace()).id(vertexRef.getId());
    }

    public static VertexRef immutableCopy(VertexRef vertexRef) {
        if (vertexRef == null || vertexRef instanceof ImmutableVertexRef) {
            return vertexRef;
        }
        return ImmutableVertexRef.newBuilderFrom(vertexRef).build();
    }

    public static final class Builder {
        private String namespace;
        private String id;

        private Builder() {
        }

        public Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace);
            return this;
        }

        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public VertexRef build() {
            return new ImmutableVertexRef(this);
        }
    }
}

