/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.core;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Properties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentService;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class DefaultCollectionAgentService
implements CollectionAgentService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCollectionAgentService.class);
    private final Integer m_ifaceId;
    private final IpInterfaceDao m_ifaceDao;

    public static CollectionAgentService create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        DefaultCollectionAgentService agent = new DefaultCollectionAgentService(ifaceId, ifaceDao);
        TransactionProxyFactoryBean bean = new TransactionProxyFactoryBean();
        bean.setTransactionManager(transMgr);
        bean.setTarget((Object)agent);
        Properties props = new Properties();
        props.put("*", "PROPAGATION_REQUIRED");
        bean.setTransactionAttributes(props);
        bean.afterPropertiesSet();
        return (CollectionAgentService)bean.getObject();
    }

    protected DefaultCollectionAgentService(Integer ifaceId, IpInterfaceDao ifaceDao) {
        this.m_ifaceId = ifaceId;
        this.m_ifaceDao = ifaceDao;
    }

    protected final OnmsIpInterface getIpInterface() {
        return (OnmsIpInterface)this.m_ifaceDao.load((Serializable)this.m_ifaceId);
    }

    public final String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    private static Boolean isStoreByForeignSource() {
        return ResourceTypeUtils.isStoreByForeignSource();
    }

    public final int getNodeId() {
        OnmsNode node = this.getIpInterface().getNode();
        return node.getId() == null ? -1 : node.getId();
    }

    public final String getNodeLabel() {
        return this.getIpInterface().getNode().getLabel();
    }

    public final String getForeignSource() {
        return this.getIpInterface().getNode().getForeignSource();
    }

    public final String getForeignId() {
        return this.getIpInterface().getNode().getForeignId();
    }

    public final String getLocationName() {
        OnmsMonitoringLocation location = this.getIpInterface().getNode().getLocation();
        if (location != null) {
            return location.getLocationName();
        }
        return null;
    }

    public final ResourcePath getStorageResourcePath() {
        String foreignSource = this.getForeignSource();
        String foreignId = this.getForeignId();
        ResourcePath dir = DefaultCollectionAgentService.createStorageResourcePath(foreignSource, foreignId, this.getNodeId());
        LOG.debug("getStorageDir: isStoreByForeignSource = {}, foreignSource = {}, foreignId = {}, dir = {}", new Object[]{DefaultCollectionAgentService.isStoreByForeignSource(), foreignSource, foreignId, dir});
        return dir;
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    public final InetAddress getInetAddress() {
        return this.getIpInterface().getIpAddress();
    }

    protected static ResourcePath createStorageResourcePath(CollectionAgent agent) {
        Objects.requireNonNull(agent);
        return DefaultCollectionAgentService.createStorageResourcePath(agent.getForeignSource(), agent.getForeignId(), agent.getNodeId());
    }

    private static ResourcePath createStorageResourcePath(String foreignSource, String foreignId, int nodeId) {
        ResourcePath dir = DefaultCollectionAgentService.isStoreByForeignSource() != false && foreignSource != null && foreignId != null ? ResourcePath.get((String[])new String[]{"fs", foreignSource, foreignId}) : ResourcePath.get((String[])new String[]{String.valueOf(nodeId)});
        return dir;
    }
}

