/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.common;

import com.google.common.base.Strings;
import java.util.Optional;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;

public class NetflowMessage
implements Flow {
    private final FlowMessage flowMessageProto;

    public NetflowMessage(FlowMessage flowMessageProto) {
        this.flowMessageProto = flowMessageProto;
    }

    public long getTimestamp() {
        return this.flowMessageProto.getTimestamp();
    }

    public Long getBytes() {
        return this.flowMessageProto.hasNumBytes() ? Long.valueOf(this.flowMessageProto.getNumBytes().getValue()) : null;
    }

    public Flow.Direction getDirection() {
        switch (this.flowMessageProto.getDirection()) {
            case INGRESS: {
                return Flow.Direction.INGRESS;
            }
            case EGRESS: {
                return Flow.Direction.EGRESS;
            }
        }
        return Flow.Direction.INGRESS;
    }

    public String getDstAddr() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getDstAddress())) {
            return this.flowMessageProto.getDstAddress();
        }
        return null;
    }

    public Optional<String> getDstAddrHostname() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getDstHostname())) {
            return Optional.of(this.flowMessageProto.getDstHostname());
        }
        return Optional.empty();
    }

    public Long getDstAs() {
        return this.flowMessageProto.hasDstAs() ? Long.valueOf(this.flowMessageProto.getDstAs().getValue()) : null;
    }

    public Integer getDstMaskLen() {
        return this.flowMessageProto.hasDstMaskLen() ? Integer.valueOf(this.flowMessageProto.getDstMaskLen().getValue()) : null;
    }

    public Integer getDstPort() {
        return this.flowMessageProto.hasDstPort() ? Integer.valueOf(this.flowMessageProto.getDstPort().getValue()) : null;
    }

    public Integer getEngineId() {
        return this.flowMessageProto.hasEngineId() ? Integer.valueOf(this.flowMessageProto.getEngineId().getValue()) : null;
    }

    public Integer getEngineType() {
        return this.flowMessageProto.hasEngineType() ? Integer.valueOf(this.flowMessageProto.getEngineType().getValue()) : null;
    }

    public Long getDeltaSwitched() {
        return this.flowMessageProto.hasDeltaSwitched() ? Long.valueOf(this.flowMessageProto.getDeltaSwitched().getValue()) : null;
    }

    public Long getFirstSwitched() {
        return this.flowMessageProto.hasFirstSwitched() ? Long.valueOf(this.flowMessageProto.getFirstSwitched().getValue()) : null;
    }

    public int getFlowRecords() {
        return this.flowMessageProto.hasNumFlowRecords() ? this.flowMessageProto.getNumFlowRecords().getValue() : 0;
    }

    public long getFlowSeqNum() {
        return this.flowMessageProto.hasFlowSeqNum() ? this.flowMessageProto.getFlowSeqNum().getValue() : 0L;
    }

    public Integer getInputSnmp() {
        return this.flowMessageProto.hasInputSnmpIfindex() ? Integer.valueOf(this.flowMessageProto.getInputSnmpIfindex().getValue()) : null;
    }

    public Integer getIpProtocolVersion() {
        return this.flowMessageProto.hasIpProtocolVersion() ? Integer.valueOf(this.flowMessageProto.getIpProtocolVersion().getValue()) : null;
    }

    public Long getLastSwitched() {
        return this.flowMessageProto.hasLastSwitched() ? Long.valueOf(this.flowMessageProto.getLastSwitched().getValue()) : null;
    }

    public String getNextHop() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getNextHopAddress())) {
            return this.flowMessageProto.getNextHopAddress();
        }
        return null;
    }

    public Optional<String> getNextHopHostname() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getNextHopHostname())) {
            return Optional.of(this.flowMessageProto.getNextHopHostname());
        }
        return Optional.empty();
    }

    public Integer getOutputSnmp() {
        return this.flowMessageProto.hasOutputSnmpIfindex() ? Integer.valueOf(this.flowMessageProto.getOutputSnmpIfindex().getValue()) : null;
    }

    public Long getPackets() {
        return this.flowMessageProto.hasNumPackets() ? Long.valueOf(this.flowMessageProto.getNumPackets().getValue()) : null;
    }

    public Integer getProtocol() {
        return this.flowMessageProto.hasProtocol() ? Integer.valueOf(this.flowMessageProto.getProtocol().getValue()) : null;
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        switch (this.flowMessageProto.getSamplingAlgorithm()) {
            case SYSTEMATIC_COUNT_BASED_SAMPLING: {
                return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
            }
            case SYSTEMATIC_TIME_BASED_SAMPLING: {
                return Flow.SamplingAlgorithm.SystematicTimeBasedSampling;
            }
            case RANDOM_N_OUT_OF_N_SAMPLING: {
                return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
            }
            case UNIFORM_PROBABILISTIC_SAMPLING: {
                return Flow.SamplingAlgorithm.UniformProbabilisticSampling;
            }
            case PROPERTY_MATCH_FILTERING: {
                return Flow.SamplingAlgorithm.PropertyMatchFiltering;
            }
            case HASH_BASED_FILTERING: {
                return Flow.SamplingAlgorithm.HashBasedFiltering;
            }
            case FLOW_STATE_DEPENDENT_INTERMEDIATE_FLOW_SELECTION_PROCESS: {
                return Flow.SamplingAlgorithm.FlowStateDependentIntermediateFlowSelectionProcess;
            }
        }
        return Flow.SamplingAlgorithm.Unassigned;
    }

    public Double getSamplingInterval() {
        return this.flowMessageProto.hasSamplingInterval() ? Double.valueOf(this.flowMessageProto.getSamplingInterval().getValue()) : null;
    }

    public String getSrcAddr() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getSrcAddress())) {
            return this.flowMessageProto.getSrcAddress();
        }
        return null;
    }

    public Optional<String> getSrcAddrHostname() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getSrcHostname())) {
            return Optional.of(this.flowMessageProto.getSrcHostname());
        }
        return Optional.empty();
    }

    public Long getSrcAs() {
        return this.flowMessageProto.hasSrcAs() ? Long.valueOf(this.flowMessageProto.getSrcAs().getValue()) : null;
    }

    public Integer getSrcMaskLen() {
        return this.flowMessageProto.hasSrcMaskLen() ? Integer.valueOf(this.flowMessageProto.getSrcMaskLen().getValue()) : null;
    }

    public Integer getSrcPort() {
        return this.flowMessageProto.hasSrcPort() ? Integer.valueOf(this.flowMessageProto.getSrcPort().getValue()) : null;
    }

    public Integer getTcpFlags() {
        return this.flowMessageProto.hasTcpFlags() ? Integer.valueOf(this.flowMessageProto.getTcpFlags().getValue()) : null;
    }

    public Integer getTos() {
        return this.flowMessageProto.hasTos() ? Integer.valueOf(this.flowMessageProto.getTos().getValue()) : null;
    }

    public Flow.NetflowVersion getNetflowVersion() {
        switch (this.flowMessageProto.getNetflowVersion()) {
            case V5: {
                return Flow.NetflowVersion.V5;
            }
            case V9: {
                return Flow.NetflowVersion.V9;
            }
            case IPFIX: {
                return Flow.NetflowVersion.IPFIX;
            }
        }
        return Flow.NetflowVersion.V5;
    }

    public Integer getVlan() {
        return this.flowMessageProto.hasVlan() ? Integer.valueOf(this.flowMessageProto.getVlan().getValue()) : null;
    }

    public String getNodeIdentifier() {
        if (!Strings.isNullOrEmpty((String)this.flowMessageProto.getNodeIdentifier())) {
            return this.flowMessageProto.getNodeIdentifier();
        }
        return null;
    }
}

