/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.common;

import com.codahale.metrics.MetricRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import org.opennms.netmgt.flows.api.Converter;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.flows.AbstractFlowAdapter;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.common.NetflowConverter;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetflowAdapter
extends AbstractFlowAdapter<FlowMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetflowAdapter.class);

    public NetflowAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, FlowRepository flowRepository) {
        super(adapterConfig, metricRegistry, flowRepository, (Converter)new NetflowConverter());
    }

    protected FlowMessage parse(TelemetryMessageLogEntry message) {
        try {
            return FlowMessage.parseFrom((byte[])message.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Unable to parse message from proto", (Throwable)e);
            return null;
        }
    }
}

