/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client;

import com.google.common.base.Strings;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Ping;
import java.io.IOException;
import java.util.Objects;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;

public class ElasticHealthCheck
implements HealthCheck {
    private final JestClient client;
    private final String featureName;

    public ElasticHealthCheck(JestClient jestClient, String featureName) {
        this.client = Objects.requireNonNull(jestClient);
        this.featureName = Objects.requireNonNull(featureName);
    }

    public String getDescription() {
        return "Connecting to ElasticSearch ReST API (" + this.featureName + ")";
    }

    public Response perform(Context context) {
        Ping ping = new Ping.Builder().build();
        try {
            JestResult result = this.client.execute((Action)ping);
            if (result.isSucceeded() && Strings.isNullOrEmpty((String)result.getErrorMessage())) {
                return new Response(Status.Success);
            }
            return new Response(Status.Failure, Strings.isNullOrEmpty((String)result.getErrorMessage()) ? null : result.getErrorMessage());
        }
        catch (IOException e) {
            return new Response((Exception)e);
        }
    }
}

