/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.util.function.Function;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;

public class PeerFlags {
    public final AddressVersion addressVersion;
    public final Policy policy;
    public final boolean legacyASPath;
    public final boolean adjIn;

    public PeerFlags(int flags) {
        this.addressVersion = (flags >> 7 & 1) == 1 ? AddressVersion.IP_V6 : AddressVersion.IP_V4;
        this.policy = (flags >> 6 & 1) == 1 ? Policy.POST_POLICY : Policy.PRE_POLICY;
        this.legacyASPath = (flags >> 5 & 1) == 1;
        this.adjIn = (flags >> 4 & 1) == 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addressVersion", (Object)this.addressVersion).add("policy", (Object)this.policy).add("legacyASPath", this.legacyASPath).add("adjIn", this.adjIn).toString();
    }

    public InetAddress parsePaddedAddress(ByteBuf buffer) {
        return InetAddressUtils.getInetAddress((byte[])this.addressVersion.map(v -> {
            switch (v) {
                case IP_V4: {
                    BufferUtils.skip((ByteBuf)buffer, (int)12);
                    return BufferUtils.bytes((ByteBuf)buffer, (int)4);
                }
                case IP_V6: {
                    return BufferUtils.bytes((ByteBuf)buffer, (int)16);
                }
            }
            throw new IllegalStateException();
        }));
    }

    public InetAddress parseAddress(ByteBuf buffer) {
        return InetAddressUtils.getInetAddress((byte[])this.addressVersion.map(v -> {
            switch (v) {
                case IP_V4: {
                    return BufferUtils.bytes((ByteBuf)buffer, (int)4);
                }
                case IP_V6: {
                    return BufferUtils.bytes((ByteBuf)buffer, (int)16);
                }
            }
            throw new IllegalStateException();
        }));
    }

    public long parseAS(ByteBuf buffer) {
        return this.legacyASPath ? (long)BufferUtils.uint16((ByteBuf)buffer) : BufferUtils.uint32((ByteBuf)buffer);
    }

    public static enum Policy {
        PRE_POLICY,
        POST_POLICY;


        public <R> R map(Function<Policy, R> mapper) {
            return mapper.apply(this);
        }
    }

    public static enum AddressVersion {
        IP_V4,
        IP_V6;


        public <R> R map(Function<AddressVersion, R> mapper) {
            return mapper.apply(this);
        }
    }
}

