/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.osgi.jmx;

import io.hawt.osgi.jmx.OSGiToolsMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class OSGiTools
implements OSGiToolsMXBean {
    private final BundleContext bundleContext;
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    OSGiTools(BundleContext bc) {
        this.bundleContext = bc;
    }

    void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName("hawtio:type=OSGiTools");
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.mBeanServer.registerMBean(this, this.objectName);
    }

    void destroy() throws Exception {
        if (this.objectName != null && this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    @Override
    public long getLoadClassOrigin(long bundleID, String clazz) {
        Bundle b = this.bundleContext.getBundle(bundleID);
        if (b == null) {
            throw new IllegalArgumentException("Not a valid bundle ID: " + bundleID);
        }
        try {
            Class cls = b.loadClass(clazz);
            ClassLoader classLoader = cls.getClassLoader();
            if (classLoader instanceof BundleReference) {
                return ((BundleReference)classLoader).getBundle().getBundleId();
            }
            return 0L;
        }
        catch (ClassNotFoundException e) {
            return -1L;
        }
    }

    @Override
    public String getResourceURL(long bundleID, String resource) {
        Bundle b = this.bundleContext.getBundle(bundleID);
        if (b == null) {
            throw new IllegalArgumentException("Not a valid bundle ID: " + bundleID);
        }
        URL res = b.getResource(resource);
        if (res == null) {
            return null;
        }
        return res.toString();
    }
}

