/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.common.utils;

import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;

public class BsonUtils {
    private BsonUtils() {
    }

    public static Optional<BsonValue> get(BsonDocument doc, String ... path) {
        BsonDocument value = doc;
        for (String p : path) {
            if ((value = value.asDocument().get((Object)p)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Long> getInt64(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asInt64).map(BsonInt64::getValue);
    }

    public static Optional<Double> getDouble(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asDouble).map(BsonDouble::getValue);
    }

    public static Optional<Integer> getInt32(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asInt32).map(BsonInt32::getValue);
    }

    public static Optional<String> getString(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asString).map(BsonString::getValue);
    }

    public static Optional<Boolean> getBool(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asBoolean).map(BsonBoolean::getValue);
    }

    public static Optional<Iterable<BsonValue>> getArray(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asArray).map(BsonArray::getValues);
    }

    public static Optional<BsonDocument> getDocument(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asDocument);
    }

    public static <V> Optional<V> first(Optional<V> ... values) {
        return Stream.of(values).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static Optional<Instant> getTime(BsonDocument doc, String ... path) {
        return BsonUtils.get(doc, path).map(BsonValue::asDocument).map(ts -> {
            long epoch = BsonUtils.getInt64(ts, "epoch").get();
            long nanos = BsonUtils.getInt64(ts, "nanos").orElse(0L);
            return Instant.ofEpochSecond(epoch, nanos);
        });
    }
}

