/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsTopologyLogger
implements OnmsTopologyConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsTopologyLogger.class);
    private final OnmsTopologyProtocol m_protocol;
    private List<OnmsTopologyMessage> m_queue = new ArrayList<OnmsTopologyMessage>();

    public OnmsTopologyLogger(String protocol) {
        this.m_protocol = OnmsTopologyProtocol.create(protocol);
    }

    @Override
    public String getName() {
        return this.m_protocol.getId() + ":Consumer:Logger";
    }

    @Override
    public Set<OnmsTopologyProtocol> getProtocols() {
        HashSet<OnmsTopologyProtocol> protocols = new HashSet<OnmsTopologyProtocol>();
        protocols.add(this.m_protocol);
        return protocols;
    }

    @Override
    public void consume(OnmsTopologyMessage message) {
        this.m_queue.add(message);
        StringBuffer txt = new StringBuffer();
        txt.append(this.getName());
        txt.append("-");
        txt.append((Object)message.getMessagestatus());
        txt.append("-");
        txt.append(message.getMessagebody().getId());
        message.getMessagebody().accept(new TopologyVisitor(txt));
        LOG.debug(txt.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OnmsTopologyMessage> getQueue() {
        List<OnmsTopologyMessage> list = this.m_queue;
        synchronized (list) {
            return new ArrayList<OnmsTopologyMessage>(this.m_queue);
        }
    }

    public OnmsTopologyProtocol getProtocol() {
        return this.m_protocol;
    }

    private class TopologyVisitor
    implements org.opennms.netmgt.topologies.service.api.TopologyVisitor {
        private final StringBuffer txt;

        TopologyVisitor(StringBuffer txt) {
            this.txt = txt;
        }

        @Override
        public void visit(OnmsTopologyVertex vertex) {
            this.txt.append(":");
            this.txt.append(vertex.getLabel());
        }

        @Override
        public void visit(OnmsTopologyEdge edge) {
            this.txt.append(":");
            OnmsTopologyPort source = edge.getSource();
            this.txt.append(source.getVertex().getId());
            this.txt.append(":");
            this.txt.append(source.getIfname());
            this.txt.append("|");
            OnmsTopologyPort target = edge.getTarget();
            this.txt.append(target.getVertex().getId());
            this.txt.append(":");
            this.txt.append(target.getIfname());
        }
    }
}

