/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.opennms.core.ipc.sink.api.AsyncPolicy;
import org.opennms.core.ipc.sink.api.DispatchQueue;
import org.opennms.core.ipc.sink.api.DispatchQueueFactory;
import org.opennms.core.ipc.sink.offheap.QueueFileOffHeapDispatchQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueFileOffHeapDispatchQueueFactory
implements DispatchQueueFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QueueFileOffHeapDispatchQueueFactory.class);
    private final int inMemoryEntrySize;
    private final long offHeapSize;
    private final int batchSize;
    private final Path baseFilePath;
    private final Map<String, DispatchQueue<?>> queues = new ConcurrentHashMap();

    public QueueFileOffHeapDispatchQueueFactory(int inMemoryEntrySize, int batchSize, String offHeapSize, String baseFilePath) {
        this.inMemoryEntrySize = inMemoryEntrySize;
        this.batchSize = batchSize;
        this.offHeapSize = QueueFileOffHeapDispatchQueueFactory.convertToBytes(offHeapSize);
        this.baseFilePath = baseFilePath == null || baseFilePath.length() == 0 ? Paths.get(System.getProperty("karaf.data"), new String[0]) : Paths.get(baseFilePath, new String[0]);
        LOG.info("DispatchQueue factory initialized with on-heap size: {}, batch size: {}, off-heap size: {}, and file path: {}", new Object[]{this.inMemoryEntrySize, this.batchSize, this.offHeapSize, this.baseFilePath});
    }

    public <T> DispatchQueue<T> getQueue(AsyncPolicy asyncPolicy, String moduleName, Function<T, byte[]> serializer, Function<byte[], T> deserializer) {
        if (asyncPolicy.getNumThreads() > this.inMemoryEntrySize) {
            throw new IllegalArgumentException("The in memory queue size must be greater than or equal to the number of consuming threads");
        }
        return this.queues.computeIfAbsent(moduleName, k -> {
            try {
                return new QueueFileOffHeapDispatchQueue(serializer, deserializer, (String)k, this.baseFilePath, this.inMemoryEntrySize, this.batchSize, this.offHeapSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static long convertToBytes(String sizeWithSuffix) {
        long bytes;
        String sizeValue;
        String suffix;
        if (sizeWithSuffix == null || sizeWithSuffix.length() == 0) {
            return 0L;
        }
        try {
            suffix = sizeWithSuffix.substring(sizeWithSuffix.length() - 2).toLowerCase();
            sizeValue = sizeWithSuffix.substring(0, sizeWithSuffix.length() - 2).trim();
        }
        catch (IndexOutOfBoundsException e) {
            LOG.warn("Invalid file size '" + sizeWithSuffix + "'. The file size must include a size and the units. eg 128MB");
            throw e;
        }
        double value = Long.parseLong(sizeValue);
        switch (suffix) {
            case "kb": {
                bytes = (long)value * 1024L;
                break;
            }
            case "mb": {
                bytes = (long)value * 1024L * 1024L;
                break;
            }
            case "gb": {
                bytes = (long)value * 1024L * 1024L * 1024L;
                break;
            }
            default: {
                LOG.warn("Could not parse unit suffix of '" + suffix + "' from max file size '" + sizeWithSuffix + "'");
                throw new IllegalArgumentException("Invalid unit suffix " + suffix);
            }
        }
        return bytes;
    }
}

