/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.util.Objects;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.exception.InvalidFilterException;

public class DefaultFilterService
implements FilterService {
    private final FilterDao filterDao;

    public DefaultFilterService(FilterDao filterDao) {
        this.filterDao = Objects.requireNonNull(filterDao);
    }

    public void validate(String filterExpression) throws InvalidFilterException {
        try {
            this.filterDao.validateRule(filterExpression);
        }
        catch (FilterParseException ex) {
            throw new InvalidFilterException(filterExpression, ex);
        }
    }

    public boolean matches(String address, String filterExpression) {
        return this.filterDao.isValid(address, filterExpression);
    }
}

