/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.bulk;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.core.BulkResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.opennms.features.jest.client.bulk.BulkException;
import org.opennms.features.jest.client.bulk.BulkResultWrapper;
import org.opennms.features.jest.client.bulk.BulkWrapper;
import org.opennms.features.jest.client.bulk.DefaultBulkResult;
import org.opennms.features.jest.client.bulk.EmptyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkRequest<T> {
    public static long[] SLEEP_TIME = new long[]{500L, 1000L, 5000L, 10000L, 30000L, 60000L};
    private static final Logger LOG = LoggerFactory.getLogger(BulkRequest.class);
    private final JestClient client;
    private final List<T> documents;
    private final Function<List<T>, BulkWrapper> transformer;
    private final int retryCount;
    private int retries = 0;
    private BulkWrapper bulkAction;

    public BulkRequest(JestClient client, List<T> documents, Function<List<T>, BulkWrapper> documentToBulkTransformer, int retryCount) {
        this.client = Objects.requireNonNull(client);
        this.transformer = Objects.requireNonNull(documentToBulkTransformer);
        this.documents = new ArrayList<T>((Collection)Objects.requireNonNull(documents));
        this.retryCount = retryCount;
    }

    public BulkResultWrapper execute() throws IOException {
        do {
            block7: {
                try {
                    BulkResultWrapper bulkResultWrapper = this.executeRequest();
                    if (bulkResultWrapper.isSucceeded()) {
                        return bulkResultWrapper;
                    }
                    List failedDocuments = bulkResultWrapper.getFailedDocuments();
                    BulkRequest.logError(bulkResultWrapper.getErrorMessage());
                    if (!this.canRetry()) {
                        throw new BulkException(bulkResultWrapper);
                    }
                    if (!failedDocuments.isEmpty() && failedDocuments.size() != this.documents.size()) {
                        this.documents.clear();
                        this.documents.addAll(failedDocuments);
                    }
                }
                catch (IOException ex) {
                    if (ex instanceof BulkException) {
                        throw ex;
                    }
                    BulkRequest.logError(ex.getMessage());
                    if (this.canRetry()) break block7;
                    throw new BulkException(ex);
                }
            }
            ++this.retries;
            BulkRequest.waitBeforeRetrying(this.retries);
            LOG.info("Retrying now ...");
        } while (this.retries != this.retryCount);
        throw new IllegalStateException("The execution of the bulk request should have failed.");
    }

    private boolean canRetry() {
        return this.retries < this.retryCount - 1;
    }

    private BulkResultWrapper executeRequest() throws IOException {
        this.bulkAction = this.createBulk(this.bulkAction, this.documents);
        if (this.bulkAction.isEmpty()) {
            return new EmptyResult();
        }
        BulkResult bulkResult = (BulkResult)this.client.execute((Action)this.bulkAction);
        DefaultBulkResult<T> bulkResultWrapper = new DefaultBulkResult<T>(bulkResult, this.documents);
        return bulkResultWrapper;
    }

    private BulkWrapper createBulk(BulkWrapper bulk, List<T> documents) {
        if (bulk == null || bulk.size() != documents.size()) {
            return this.transformer.apply(documents);
        }
        return bulk;
    }

    private static void waitBeforeRetrying(int retries) {
        try {
            long sleepTime = BulkRequest.getSleepTime(retries);
            if (sleepTime > 0L) {
                LOG.info("Waiting {} ms before retrying", (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void logError(String errorMessage) {
        LOG.info("An error occurred while executing the bulk request: {}.", (Object)errorMessage);
    }

    public static long getSleepTime(int retry) {
        int index = Math.min(retry, SLEEP_TIME.length - 1);
        return SLEEP_TIME[index];
    }
}

