/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.csv.CsvImportResult;
import org.opennms.netmgt.flows.classification.csv.CsvService;
import org.opennms.netmgt.flows.classification.error.Errors;
import org.opennms.netmgt.flows.classification.exception.CSVImportException;
import org.opennms.netmgt.flows.classification.exception.ClassificationException;
import org.opennms.netmgt.flows.classification.exception.InvalidRuleException;
import org.opennms.netmgt.flows.classification.internal.PositionUtil;
import org.opennms.netmgt.flows.classification.internal.csv.CsvServiceImpl;
import org.opennms.netmgt.flows.classification.internal.validation.GroupValidator;
import org.opennms.netmgt.flows.classification.internal.validation.RuleValidator;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationGroupDao;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationRuleDao;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultClassificationService
implements ClassificationService {
    private final ClassificationRuleDao classificationRuleDao;
    private final ClassificationGroupDao classificationGroupDao;
    private final ClassificationEngine classificationEngine;
    private final RuleValidator ruleValidator;
    private final CsvService csvService;
    private final GroupValidator groupValidator;
    private final TransactionOperations transactionTemplate;

    public DefaultClassificationService(ClassificationRuleDao classificationRuleDao, ClassificationGroupDao classificationGroupDao, ClassificationEngine classificationEngine, FilterService filterService, TransactionOperations transactionOperations) {
        this.classificationRuleDao = Objects.requireNonNull(classificationRuleDao);
        this.classificationGroupDao = Objects.requireNonNull(classificationGroupDao);
        this.classificationEngine = Objects.requireNonNull(classificationEngine);
        this.transactionTemplate = Objects.requireNonNull(transactionOperations);
        this.ruleValidator = new RuleValidator(filterService);
        this.groupValidator = new GroupValidator(classificationRuleDao);
        this.csvService = new CsvServiceImpl(this.ruleValidator);
    }

    public List<Rule> findMatchingRules(Criteria criteria) {
        return this.classificationRuleDao.findMatching(criteria);
    }

    public int countMatchingRules(Criteria criteria) {
        return this.classificationRuleDao.countMatching(criteria);
    }

    public Rule getRule(int ruleId) {
        Rule rule = (Rule)this.classificationRuleDao.get((Serializable)Integer.valueOf(ruleId));
        if (rule == null) {
            throw new NoSuchElementException();
        }
        return rule;
    }

    public Integer saveRule(Rule rule) throws InvalidRuleException {
        return (Integer)this.runInTransaction(status -> {
            this.ruleValidator.validate(rule);
            Group group = (Group)this.classificationGroupDao.get((Serializable)rule.getGroup().getId());
            if (group == null) {
                throw new NoSuchElementException(String.format("Unknown group with id=%s", rule.getGroup().getId()));
            }
            this.assertRuleIsNotInReadOnlyGroup(group);
            this.groupValidator.validate(group, rule);
            group.addRule(rule);
            Integer ruleId = (Integer)this.classificationRuleDao.save((Object)rule);
            this.updateRulePositionsAndReloadEngine(PositionUtil.sortRulePositions(rule));
            return ruleId;
        });
    }

    public void importRules(int groupId, InputStream inputStream, boolean hasHeader, boolean deleteExistingRules) throws CSVImportException {
        this.runInTransaction(status -> {
            Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
            if (group == null) {
                throw new ClassificationException("name", Errors.GROUP_NOT_FOUND, new Object[]{groupId});
            }
            if (group.isReadOnly()) {
                throw new ClassificationException("name", Errors.GROUP_READ_ONLY, new Object[]{groupId});
            }
            CsvImportResult result = this.csvService.parseCSV(group, inputStream, hasHeader);
            if (!result.isSuccess()) {
                throw new CSVImportException(result);
            }
            if (deleteExistingRules) {
                for (Rule eachRule : group.getRules()) {
                    this.classificationRuleDao.delete((Object)eachRule);
                }
                group.getRules().clear();
            }
            List rules = result.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                Rule rule = (Rule)rules.get(i);
                try {
                    this.groupValidator.validate(group, rule);
                    group.addRule(rule);
                    continue;
                }
                catch (ClassificationException ex) {
                    result.markError((long)i, ex.getError());
                }
            }
            if (!result.isSuccess()) {
                throw new CSVImportException(result);
            }
            this.updateRulePositionsAndReloadEngine(PositionUtil.sortRulePositions(group.getRules()));
            this.classificationGroupDao.saveOrUpdate((Object)group);
            return null;
        });
    }

    public String exportRules(int groupId) {
        Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
        if (group == null) {
            throw new NoSuchElementException();
        }
        String csvContent = this.csvService.createCSV(group.getRules());
        return csvContent;
    }

    public void deleteRules(int groupId) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(Rule.class).alias("group", "group");
        criteriaBuilder.eq("group.id", (Object)groupId);
        this.runInTransaction(status -> {
            Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
            if (group == null) {
                throw new NoSuchElementException();
            }
            if (group.isReadOnly()) {
                throw new ClassificationException("entity", Errors.GROUP_READ_ONLY, new Object[0]);
            }
            Criteria criteria = criteriaBuilder.toCriteria();
            this.classificationRuleDao.findMatching(criteria).forEach(r -> this.classificationRuleDao.delete(r));
            this.classificationEngine.reload();
            return null;
        });
    }

    public void deleteRule(int ruleId) {
        this.runInTransaction(status -> {
            Rule rule = (Rule)this.classificationRuleDao.get((Serializable)Integer.valueOf(ruleId));
            if (rule == null) {
                throw new NoSuchElementException();
            }
            this.assertRuleIsNotInReadOnlyGroup(rule);
            return this.runInTransaction(transactionStatus -> {
                Group group = rule.getGroup();
                group.removeRule(rule);
                this.classificationRuleDao.delete((Object)rule);
                this.updateRulePositionsAndReloadEngine(PositionUtil.sortRulePositions(group.getRules()));
                return null;
            });
        });
    }

    public void updateRule(Rule rule) {
        if (rule.getId() == null) {
            throw new NoSuchElementException();
        }
        this.assertRuleIsNotInReadOnlyGroup(rule);
        this.runInTransaction(status -> {
            this.ruleValidator.validate(rule);
            this.groupValidator.validate(rule.getGroup(), rule);
            this.classificationRuleDao.saveOrUpdate((Object)rule);
            Rule reloaded = (Rule)this.classificationRuleDao.get((Serializable)rule.getId());
            this.updateRulePositionsAndReloadEngine(PositionUtil.sortRulePositions(reloaded));
            return null;
        });
    }

    private void assertRuleIsNotInReadOnlyGroup(Rule rule) {
        this.assertRuleIsNotInReadOnlyGroup(rule.getGroup());
    }

    private void assertRuleIsNotInReadOnlyGroup(Group group) {
        if (group.isReadOnly()) {
            throw new ClassificationException("entity", Errors.GROUP_READ_ONLY, new Object[0]);
        }
    }

    public String classify(ClassificationRequest classificationRequest) {
        String classification = this.classificationEngine.classify(classificationRequest);
        return classification;
    }

    public List<Group> findMatchingGroups(Criteria criteria) {
        return this.classificationGroupDao.findMatching(criteria);
    }

    public int countMatchingGroups(Criteria criteria) {
        return this.classificationGroupDao.countMatching(criteria);
    }

    public Group getGroup(int groupId) {
        Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
        if (group == null) {
            throw new NoSuchElementException();
        }
        return group;
    }

    public Integer saveGroup(Group group) {
        this.checkForDuplicateName(group);
        return (Integer)this.runInTransaction(status -> {
            Integer groupId = (Integer)this.classificationGroupDao.save((Object)group);
            this.updateGroupPositionsAndReloadEngine(PositionUtil.sortGroupPositions(group, this.classificationGroupDao.findAll()));
            return groupId;
        });
    }

    public void deleteGroup(int groupId) {
        this.runInTransaction(status -> {
            Group group = (Group)this.classificationGroupDao.get((Serializable)Integer.valueOf(groupId));
            if (group == null) {
                throw new NoSuchElementException();
            }
            if (group.isReadOnly()) {
                throw new ClassificationException("entity", Errors.GROUP_READ_ONLY, new Object[0]);
            }
            this.classificationGroupDao.delete((Object)group);
            this.updateGroupPositionsAndReloadEngine(PositionUtil.sortGroupPositions(this.classificationGroupDao.findAll()));
            this.classificationEngine.reload();
            return null;
        });
    }

    public void updateGroup(Group group) {
        if (group.getId() == null) {
            throw new NoSuchElementException();
        }
        this.checkForDuplicateName(group);
        this.runInTransaction(status -> {
            this.classificationGroupDao.saveOrUpdate((Object)group);
            this.updateGroupPositionsAndReloadEngine(PositionUtil.sortGroupPositions(group, this.classificationGroupDao.findAll()));
            this.updateRulePositionsAndReloadEngine(PositionUtil.sortRulePositions(group.getRules()));
            return null;
        });
    }

    private <T> T runInTransaction(TransactionCallback<T> callback) {
        return (T)this.transactionTemplate.execute(callback);
    }

    private void updateRulePositionsAndReloadEngine(List<Rule> rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = rules.get(i);
            rule.setPosition(i);
            this.classificationRuleDao.saveOrUpdate((Object)rule);
        }
        this.classificationEngine.reload();
    }

    private void updateGroupPositionsAndReloadEngine(List<Group> groups) {
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            group.setPosition(i);
            this.classificationGroupDao.saveOrUpdate((Object)group);
        }
        this.classificationEngine.reload();
    }

    private void checkForDuplicateName(Group group) {
        CriteriaBuilder builder = new CriteriaBuilder(Group.class).eq("name", (Object)group.getName());
        if (group.getId() != null) {
            builder.ne("id", (Object)group.getId());
        }
        if (this.countMatchingGroups(builder.toCriteria()) > 0) {
            throw new ClassificationException("entity", Errors.GROUP_NAME_NOT_UNIQUE, new Object[]{group.getName()});
        }
    }
}

