/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThresholdEvaluatorHighLow
implements ThresholdEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdEvaluatorHighLow.class);

    @Override
    public boolean supportsType(ThresholdType type) {
        return ThresholdType.LOW.equals((Object)type) || ThresholdType.HIGH.equals((Object)type);
    }

    @Override
    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        return new ThresholdEvaluatorStateHighLow(threshold, thresholdingSession);
    }

    public static class ThresholdEvaluatorStateHighLow
    extends AbstractThresholdEvaluatorState<State> {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;
        private CollectionResourceWrapper m_lastCollectionResourceUsed;

        public ThresholdEvaluatorStateHighLow(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
            super(threshold, thresholdingSession);
            this.setThresholdConfig(threshold);
        }

        @Override
        protected void initializeState() {
            this.state = new State();
            this.setExceededCount(0);
            this.setArmed(true);
        }

        private boolean isArmed() {
            return ((State)this.state).m_armed;
        }

        private void setArmed(boolean armed) {
            if (armed != ((State)this.state).m_armed) {
                ((State)this.state).m_armed = armed;
                this.markDirty();
            }
        }

        private int getExceededCount() {
            return ((State)this.state).m_exceededCount;
        }

        private void setExceededCount(int exceededCount) {
            if (exceededCount != ((State)this.state).m_exceededCount) {
                ((State)this.state).m_exceededCount = exceededCount;
                this.markDirty();
            }
        }

        @Override
        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        private void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            this.m_thresholdConfig = thresholdConfig;
        }

        private ThresholdType getType() {
            return this.getThresholdConfig().getType();
        }

        @Override
        public ThresholdEvaluatorState.Status evaluateAfterFetch(double dsValue) {
            if (this.isThresholdExceeded(dsValue)) {
                if (this.isArmed()) {
                    this.setExceededCount(this.getExceededCount() + 1);
                    LOG.debug("evaluate: {} threshold exceeded, count={}", (Object)this.getType(), (Object)this.getExceededCount());
                    if (this.isTriggerCountExceeded()) {
                        LOG.debug("evaluate: {} threshold triggered", (Object)this.getType());
                        this.setExceededCount(1);
                        this.setArmed(false);
                        return ThresholdEvaluatorState.Status.TRIGGERED;
                    }
                }
            } else if (this.isRearmExceeded(dsValue)) {
                if (!this.isArmed()) {
                    LOG.debug("evaluate: {} threshold rearmed", (Object)this.getType());
                    this.setArmed(true);
                    this.setExceededCount(0);
                    return ThresholdEvaluatorState.Status.RE_ARMED;
                }
                if (this.getExceededCount() > 0) {
                    LOG.debug("evaluate: resetting {} threshold count to 0, because the current value indicates that the in-progress threshold has been rearmed, but it doesn't triggered yet.", (Object)this.getType());
                    this.setExceededCount(0);
                }
            } else {
                LOG.debug("evaluate: resetting {} threshold count to 0", (Object)this.getType());
                this.setExceededCount(0);
            }
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        protected boolean isThresholdExceeded(double dsValue) {
            if (ThresholdType.HIGH.equals((Object)this.getThresholdConfig().getType())) {
                return dsValue >= this.getThresholdConfig().getValue();
            }
            if (ThresholdType.LOW.equals((Object)this.getThresholdConfig().getType())) {
                return dsValue <= this.getThresholdConfig().getValue();
            }
            throw new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'.");
        }

        protected boolean isRearmExceeded(double dsValue) {
            if (ThresholdType.HIGH.equals((Object)this.getThresholdConfig().getType())) {
                return dsValue <= this.getThresholdConfig().getRearm();
            }
            if (ThresholdType.LOW.equals((Object)this.getThresholdConfig().getType())) {
                return dsValue >= this.getThresholdConfig().getRearm();
            }
            throw new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'.");
        }

        protected boolean isTriggerCountExceeded() {
            return this.getExceededCount() >= this.getThresholdConfig().getTrigger();
        }

        @Override
        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, CollectionResourceWrapper resource) {
            if (resource == null) {
                resource = this.m_lastCollectionResourceUsed;
            }
            this.m_lastCollectionResourceUsed = resource;
            switch (status) {
                case TRIGGERED: {
                    String uei = this.getThresholdConfig().getTriggeredUEI().orElse(null);
                    if (ThresholdType.LOW.equals((Object)this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/lowThresholdExceeded";
                        }
                        return this.createBasicEvent(uei, date, dsValue, resource);
                    }
                    if (ThresholdType.HIGH.equals((Object)this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/highThresholdExceeded";
                        }
                        return this.createBasicEvent(uei, date, dsValue, resource);
                    }
                    throw new IllegalArgumentException("Threshold type " + this.getThresholdConfig().getType() + " is not supported");
                }
                case RE_ARMED: {
                    String uei = this.getThresholdConfig().getRearmedUEI().orElse(null);
                    if (ThresholdType.LOW.equals((Object)this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/lowThresholdRearmed";
                        }
                        return this.createBasicEvent(uei, date, dsValue, resource);
                    }
                    if (ThresholdType.HIGH.equals((Object)this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/highThresholdRearmed";
                        }
                        return this.createBasicEvent(uei, date, dsValue, resource);
                    }
                    throw new IllegalArgumentException("Threshold type " + this.getThresholdConfig().getType() + " is not supported");
                }
                case NO_CHANGE: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Status " + (Object)((Object)status) + " is not supported for converting to an event.");
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("threshold", Double.toString(this.getThresholdConfig().getValue()));
            params.put("trigger", Integer.toString(this.getThresholdConfig().getTrigger()));
            params.put("rearm", Double.toString(this.getThresholdConfig().getRearm()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        @Override
        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateHighLow(this.m_thresholdConfig, this.getThresholdingSession());
        }

        @Override
        public boolean isTriggered() {
            return !this.isArmed();
        }

        @Override
        public void clearStateBeforePersist() {
            this.setArmed(true);
            this.setExceededCount(0);
        }

        static class State
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private int m_exceededCount;
            private boolean m_armed;

            State() {
            }

            public String toString() {
                return "exceededCount=" + this.m_exceededCount + "\narmed=" + this.m_armed;
            }
        }
    }
}

