/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThresholdingDao;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultThresholdsDao
implements ThresholdsDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultThresholdsDao.class);
    private ThresholdingEventProxy m_eventProxy;
    private ReadableThresholdingDao m_thresholdingDao;

    @Override
    public ThresholdGroup get(String name, ThresholdingSession thresholdingSession) {
        return this.get(name, null, thresholdingSession);
    }

    @Override
    public ThresholdGroup merge(ThresholdGroup group, ThresholdingSession thresholdingSession) {
        return this.get(group.getName(), group, thresholdingSession);
    }

    private ThresholdGroup get(String name, ThresholdGroup group, ThresholdingSession thresholdingSession) {
        boolean merge = group != null;
        ThresholdGroup newGroup = new ThresholdGroup(name);
        File rrdRepository = new File(((ThresholdingConfig)this.m_thresholdingDao.getReadOnlyConfig()).getGroup(name).getRrdRepository());
        newGroup.setRrdRepository(rrdRepository);
        ThresholdResourceType nodeType = this.getThresholdResourceType(name, "node", merge ? group.getNodeResourceType() : null, thresholdingSession);
        newGroup.setNodeResourceType(nodeType);
        ThresholdResourceType ifType = this.getThresholdResourceType(name, "if", merge ? group.getIfResourceType() : null, thresholdingSession);
        newGroup.setIfResourceType(ifType);
        for (Basethresholddef thresh : ((ThresholdingConfig)this.m_thresholdingDao.getReadOnlyConfig()).getGroup(name).getThresholdsAndExpressions()) {
            ThresholdResourceType genericType;
            String id = thresh.getDsType();
            if (id.equals("if") || id.equals("node") || newGroup.getGenericResourceTypeMap().containsKey(id) || (genericType = this.getThresholdResourceType(name, id, merge ? group.getGenericResourceTypeMap().get(id) : null, thresholdingSession)).getThresholdMap().size() <= 0) continue;
            LOG.info("Adding {}::{} with {} elements", new Object[]{name, id, genericType.getThresholdMap().size()});
            newGroup.getGenericResourceTypeMap().put(id, genericType);
        }
        return newGroup;
    }

    private ThresholdResourceType getThresholdResourceType(String groupName, String typeName, ThresholdResourceType type, ThresholdingSession thresholdingSession) {
        ThresholdResourceType resourceType = new ThresholdResourceType(typeName);
        Map<String, Set<ThresholdEntity>> thresholdMap = null;
        if (type == null) {
            thresholdMap = new HashMap<String, Set<ThresholdEntity>>();
            this.fillThresholdStateMap(groupName, typeName, thresholdMap, thresholdingSession);
        } else {
            thresholdMap = type.getThresholdMap();
            this.fillThresholdStateMap(groupName, type.getDsType(), thresholdMap, thresholdingSession);
        }
        resourceType.setThresholdMap(thresholdMap);
        return resourceType;
    }

    private void fillThresholdStateMap(String groupName, String typeName, Map<String, Set<ThresholdEntity>> thresholdMap, ThresholdingSession thresholdingSession) {
        boolean merge = !thresholdMap.isEmpty();
        for (Basethresholddef basethresholddef : ((ThresholdingConfig)this.m_thresholdingDao.getReadOnlyConfig()).getGroup(groupName).getThresholdsAndExpressions()) {
            if (!basethresholddef.getDsType().equals(typeName)) continue;
            try {
                BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(basethresholddef);
                Set<ThresholdEntity> thresholdEntitySet = thresholdMap.get(wrapper.getDatasourceExpression());
                if (thresholdEntitySet == null) {
                    thresholdEntitySet = new LinkedHashSet<ThresholdEntity>();
                    thresholdMap.put(wrapper.getDatasourceExpression(), thresholdEntitySet);
                }
                try {
                    ThresholdEntity thresholdEntity = new ThresholdEntity();
                    thresholdEntity.setEventProxy(this.m_eventProxy);
                    thresholdEntity.addThreshold(wrapper, thresholdingSession);
                    if (merge) {
                        boolean updated = false;
                        for (ThresholdEntity e : thresholdEntitySet) {
                            if (!thresholdEntity.getThresholdConfig().equals(e.getThresholdConfig())) continue;
                            e.merge(thresholdEntity);
                            updated = true;
                        }
                        if (updated) continue;
                        thresholdEntitySet.add(thresholdEntity);
                        continue;
                    }
                    thresholdEntitySet.add(thresholdEntity);
                }
                catch (IllegalStateException e) {
                    LOG.warn("fillThresholdStateMap: Encountered duplicate {} for datasource {}", new Object[]{basethresholddef.getType(), wrapper.getDatasourceExpression(), e});
                }
            }
            catch (ThresholdExpressionException e) {
                LOG.warn("fillThresholdStateMap: Could not parse threshold expression", (Throwable)e);
            }
        }
        if (merge) {
            LOG.debug("fillThresholdStateMap(merge): checking if definitions that are no longer exist for group {} using type {}", (Object)groupName, (Object)typeName);
            for (Map.Entry entry : thresholdMap.entrySet()) {
                Set value = (Set)entry.getValue();
                Iterator thresholdIterator = value.iterator();
                while (thresholdIterator.hasNext()) {
                    ThresholdEntity entity = (ThresholdEntity)thresholdIterator.next();
                    boolean found = false;
                    for (Basethresholddef thresh : ((ThresholdingConfig)this.m_thresholdingDao.getReadOnlyConfig()).getGroup(groupName).getThresholdsAndExpressions()) {
                        BaseThresholdDefConfigWrapper newConfig = null;
                        try {
                            newConfig = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                        }
                        catch (ThresholdExpressionException e) {
                            LOG.warn("fillThresholdStateMap: Could not parse threshold expression", (Throwable)e);
                        }
                        if (newConfig == null || !newConfig.equals(entity.getThresholdConfig())) continue;
                        found = true;
                    }
                    if (found) continue;
                    LOG.info("fillThresholdStateMap(merge): deleting entity {}", (Object)entity);
                    entity.delete();
                    thresholdIterator.remove();
                }
            }
        }
    }

    public void setThresholdingDao(ReadableThresholdingDao thresholdingDao) {
        this.m_thresholdingDao = Objects.requireNonNull(thresholdingDao);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_thresholdingDao != null ? 1 : 0) != 0, (String)"thresholdingDao property not set");
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }
}

