/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThresholdingDao;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.threshd.ThresholdingSessionImpl;
import org.opennms.netmgt.threshd.ThresholdingSetImpl;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.threshd.api.ThresholdingSessionKey;
import org.opennms.netmgt.threshd.api.ThresholdingSet;
import org.opennms.netmgt.threshd.api.ThresholdingSetPersister;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultThresholdingSetPersister
implements ThresholdingSetPersister {
    private Map<ThresholdingSessionKey, ThresholdingSet> thresholdingSets = new HashMap<ThresholdingSessionKey, ThresholdingSet>();
    @Autowired
    private ReadableThreshdDao threshdDao;
    @Autowired
    private ReadableThresholdingDao thresholdingDao;
    @Autowired
    private ReadablePollOutagesDao pollOutagesDao;
    @Autowired
    private IfLabel ifLabelDao;

    public void persistSet(ThresholdingSession session, ThresholdingSet set) {
        this.thresholdingSets.put(session.getKey(), set);
    }

    public ThresholdingSet getThresholdingSet(ThresholdingSession session, ThresholdingEventProxy eventProxy) throws ThresholdInitializationException {
        ThresholdingSessionKey key = session.getKey();
        ThresholdingSet tSet = this.thresholdingSets.get(key);
        if (tSet == null) {
            tSet = new ThresholdingSetImpl(key.getNodeId(), key.getLocation(), key.getServiceName(), ((ThresholdingSessionImpl)session).getRrdRepository(), ((ThresholdingSessionImpl)session).getServiceParameters(), ((ThresholdingSessionImpl)session).getResourceDao(), eventProxy, session, this.threshdDao, this.thresholdingDao, this.pollOutagesDao, this.ifLabelDao);
            this.thresholdingSets.put(key, tSet);
        }
        return tSet;
    }

    public void reinitializeThresholdingSets() {
        this.thresholdingSets.values().forEach(set -> set.reinitialize());
    }

    public void clear(ThresholdingSession session) {
        ThresholdingSessionKey key = session.getKey();
        this.thresholdingSets.remove(key);
    }

    public void setThreshdDao(ReadableThreshdDao threshdDao) {
        this.threshdDao = Objects.requireNonNull(threshdDao);
    }

    public void setThresholdingDao(ReadableThresholdingDao thresholdingDao) {
        this.thresholdingDao = Objects.requireNonNull(thresholdingDao);
    }

    public void setPollOutagesDao(ReadablePollOutagesDao pollOutagesDao) {
        this.pollOutagesDao = Objects.requireNonNull(pollOutagesDao);
    }

    public void setIfLabelDao(IfLabel ifLabelDao) {
        this.ifLabelDao = Objects.requireNonNull(ifLabelDao);
    }
}

