/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.distributed.kvstore.api.SerializingBlobStore;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRearmingAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThresholdEvaluatorState<T extends Serializable>
implements ThresholdEvaluatorState {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThresholdEvaluatorState.class);
    private static final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.standardSeconds((long)30L)).build();
    private static final String UNKNOWN = "Unknown";
    public static final String FORMATED_NAN = "NaN (the threshold definition has been changed)";
    public static final FSTConfiguration fst = FSTConfiguration.createDefaultConfiguration();
    private boolean isStateDirty;
    private final String key;
    private final SerializingBlobStore<T> kvStore;
    protected T state;
    protected final ThresholdingSession thresholdingSession;
    private static final String THRESHOLDING_KV_CONTEXT = "thresholding";
    private final int stateTTL;
    private Long sequenceNumber;
    private boolean firstEvaluation = true;
    private final Map<String, Long> lastUpdatedCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String key) {
            return null;
        }
    }).asMap();

    public AbstractThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        Objects.requireNonNull(threshold);
        Objects.requireNonNull(thresholdingSession);
        Objects.requireNonNull(thresholdingSession.getBlobStore());
        this.thresholdingSession = thresholdingSession;
        this.kvStore = new SerializingBlobStore(thresholdingSession.getBlobStore(), arg_0 -> ((FSTConfiguration)fst).asByteArray(arg_0), bytes -> (Serializable)fst.asObject(bytes));
        this.key = String.format("%d-%s-%s-%s-%s-%s", thresholdingSession.getKey().getNodeId(), thresholdingSession.getKey().getLocation(), threshold.getDsType(), threshold.getDatasourceExpression(), thresholdingSession.getKey().getResource(), threshold.getType());
        this.stateTTL = SystemProperties.getInteger((String)"org.opennms.netmgt.threshd.state_ttl", (int)((int)TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS)));
        this.initializeState();
    }

    protected abstract void initializeState();

    private boolean shouldPersist() {
        return this.isStateDirty;
    }

    private void persistStateIfNeeded() {
        if (this.shouldPersist()) {
            try {
                long newTimestamp = this.kvStore.put(this.key, this.state, THRESHOLDING_KV_CONTEXT, Integer.valueOf(this.stateTTL));
                this.lastUpdatedCache.put(this.key, newTimestamp);
                this.isStateDirty = false;
            }
            catch (RuntimeException e) {
                RATE_LIMITED_LOGGER.warn("Failed to store state for threshold {}", (Object)this.key, (Object)e);
            }
        }
    }

    private void fetchState() {
        if (!this.isDistributed() && !this.firstEvaluation) {
            return;
        }
        try {
            Long lastKnownUpdate = this.lastUpdatedCache.get(this.key);
            if (lastKnownUpdate == null) {
                this.kvStore.get(this.key, THRESHOLDING_KV_CONTEXT).ifPresent(v -> {
                    this.state = v;
                });
            } else {
                this.kvStore.getIfStale(this.key, THRESHOLDING_KV_CONTEXT, lastKnownUpdate.longValue()).ifPresent(o -> o.ifPresent(v -> {
                    this.state = v;
                }));
            }
        }
        catch (RuntimeException e) {
            RATE_LIMITED_LOGGER.warn("Failed to retrieve state for threshold {}", (Object)this.key, (Object)e);
        }
    }

    protected void markDirty() {
        this.isStateDirty = true;
    }

    @Override
    public ThresholdEvaluatorState.Status evaluate(double dsValue, Long sequenceNumber) {
        if (sequenceNumber != null) {
            if (this.sequenceNumber == null || sequenceNumber != this.sequenceNumber + 1L) {
                this.fetchState();
            }
            this.sequenceNumber = sequenceNumber;
        } else {
            this.fetchState();
        }
        ThresholdEvaluatorState.Status status = this.evaluateAfterFetch(dsValue);
        this.persistStateIfNeeded();
        this.firstEvaluation = false;
        return status;
    }

    @Override
    public void clearState() {
        this.clearStateBeforePersist();
        this.persistStateIfNeeded();
    }

    protected abstract void clearStateBeforePersist();

    protected abstract ThresholdEvaluatorState.Status evaluateAfterFetch(double var1);

    protected Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource, Map<String, String> additionalParams) {
        String dsLabelValue;
        if (resource == null) {
            resource = new CollectionResourceWrapper(date, 0, null, null, null, null, null, null, null, null);
        }
        if ((dsLabelValue = resource.getFieldValue(resource.getDsLabel())) == null) {
            dsLabelValue = UNKNOWN;
        }
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression(), date);
        bldr.setNodeid((long)resource.getNodeId());
        bldr.setService(resource.getServiceName());
        bldr.setInterface(InetAddressUtils.addr((String)resource.getHostAddress()));
        if (resource.isAnInterfaceResource() || resource.isLatencyResource()) {
            String ipaddr;
            if (UNKNOWN.equals(dsLabelValue)) {
                dsLabelValue = resource.getIfLabel();
            }
            bldr.addParam("ifLabel", resource.getIfLabel());
            if (resource.getIfIndex() != null) {
                bldr.addParam("ifIndex", resource.getIfIndex());
            }
            if ((ipaddr = resource.getIfInfoValue("ipaddr")) != null && !"0.0.0.0".equals(ipaddr)) {
                bldr.addParam("ifIpAddress", ipaddr);
            }
        }
        if (resource.isNodeResource() && UNKNOWN.equals(dsLabelValue)) {
            dsLabelValue = "node";
        }
        bldr.addParam("label", dsLabelValue);
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.addParam("ds", this.getThresholdConfig().getDatasourceExpression());
        String descr = this.getThresholdConfig().getBasethresholddef().getDescription().orElse(this.getThresholdConfig().getDatasourceExpression());
        bldr.addParam("description", descr);
        bldr.addParam("value", this.formatValue(dsValue));
        String defaultInstance = resource.isNodeResource() ? "node" : UNKNOWN;
        bldr.addParam("instance", resource.getInstance() == null ? defaultInstance : resource.getInstance());
        bldr.addParam("instanceLabel", resource.getInstanceLabel() == null ? defaultInstance : resource.getInstanceLabel());
        bldr.addParam("resourceType", resource.getResourceTypeName());
        ResourceId resourceId = resource.getResourceId();
        bldr.addParam("resourceId", resourceId != null ? resourceId.toString() : null);
        if (additionalParams != null) {
            for (String p : additionalParams.keySet()) {
                bldr.addParam(p, additionalParams.get(p));
            }
        }
        return bldr.getEvent();
    }

    protected String formatValue(double value) {
        if (Double.isNaN(value)) {
            return FORMATED_NAN;
        }
        String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
        DecimalFormat valueFormatter = new DecimalFormat(pattern);
        return valueFormatter.format(value);
    }

    @Override
    public ThresholdingSession getThresholdingSession() {
        return this.thresholdingSession;
    }

    private boolean isDistributed() {
        return this.thresholdingSession.isDistributed();
    }

    static {
        fst.registerClass(new Class[]{ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow.State.class, ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange.State.class, ThresholdEvaluatorRearmingAbsoluteChange.ThresholdEvaluatorStateRearmingAbsoluteChange.State.class, ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange.State.class});
    }
}

