/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.template;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import org.opennms.plugins.elasticsearch.rest.template.IndexSettings;

public class TemplateMerger {
    private static final String SETTINGS_KEY = "settings";
    private static final String INDEX_KEY = "index";

    public String merge(String template, IndexSettings indexSettings) {
        JsonElement json = new JsonParser().parse(template);
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException("Provided template is not a valid json object");
        }
        JsonObject object = this.merge(json.getAsJsonObject(), indexSettings);
        return new Gson().toJson((JsonElement)object);
    }

    public JsonObject merge(JsonObject template, IndexSettings indexSettings) {
        if (indexSettings != null && !indexSettings.isEmpty()) {
            this.addMissingProperties(template);
            if (!Strings.isNullOrEmpty((String)indexSettings.getIndexPrefix())) {
                JsonPrimitive templateName = template.getAsJsonPrimitive("template");
                if (templateName == null) {
                    template.addProperty("template", indexSettings.getIndexPrefix());
                } else {
                    template.addProperty("template", indexSettings.getIndexPrefix() + templateName.getAsString());
                }
            }
            JsonObject indexObject = template.get(SETTINGS_KEY).getAsJsonObject().get(INDEX_KEY).getAsJsonObject();
            if (indexSettings.getNumberOfShards() != null) {
                indexObject.addProperty("number_of_shards", (Number)indexSettings.getNumberOfShards());
            }
            if (indexSettings.getNumberOfReplicas() != null) {
                indexObject.addProperty("number_of_replicas", (Number)indexSettings.getNumberOfReplicas());
            }
            if (indexSettings.getRefreshInterval() != null) {
                indexObject.addProperty("refresh_interval", indexSettings.getRefreshInterval());
            }
            if (indexSettings.getRoutingPartitionSize() != null) {
                indexObject.addProperty("routing_partition_size", (Number)indexSettings.getRoutingPartitionSize());
            }
        }
        return template;
    }

    private void addMissingProperties(JsonObject template) {
        JsonObject settings = this.addMissingProperty(template, SETTINGS_KEY);
        this.addMissingProperty(settings, INDEX_KEY);
    }

    private JsonObject addMissingProperty(JsonObject root, String property) {
        if (root.get(property) == null) {
            root.add(property, (JsonElement)new JsonObject());
        }
        if (!root.get(property).isJsonObject()) {
            throw new IllegalArgumentException("Provided template contains property '" + property + "' must be of type JsonObject");
        }
        return root.get(property).getAsJsonObject();
    }
}

