/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.HealthCheckService;
import org.opennms.core.health.api.Status;
import org.opennms.core.health.shell.Color;
import org.opennms.core.health.shell.Colorizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

@Command(scope="health", name="check", description="Verifies that the container is healthy.")
@Service
public class HealthCheckCommand
implements Action {
    private static final String DESCRIPTION_FORMAT = "%%-%ds   ";
    private static final String STATUS_FORMAT = "[ %%-%ds ]";
    @Option(name="-t", description="Maximum number of milliseconds to wait before failing when waiting for a check to complete (e.g. try to establish a JMS session.")
    public long timeout = 5000L;
    @Reference
    private BundleContext bundleContext;
    @Reference
    private HealthCheckService healthCheckService;

    public Object execute() throws Exception {
        System.out.println("Verifying the health of the container");
        System.out.println();
        Context context = new Context();
        context.setTimeout(this.timeout);
        CompletableFuture<Health> future = this.performHealthCheck(this.bundleContext, context);
        Health health = future.get();
        System.out.println();
        if (health.isSuccess()) {
            System.out.println("=> Everything is awesome");
        } else {
            if (health.getErrorMessage() != null) {
                System.out.println(Colorizer.colorize("Error: " + health.getErrorMessage(), Color.Red));
            }
            System.out.println("=> Oh no, something is wrong");
        }
        return null;
    }

    private CompletableFuture<Health> performHealthCheck(BundleContext bundleContext, Context context) throws InvalidSyntaxException {
        Collection serviceReferences = bundleContext.getServiceReferences(HealthCheck.class, null);
        List healthChecks = serviceReferences.stream().map(s -> (HealthCheck)bundleContext.getService(s)).collect(Collectors.toList());
        int maxColorLength = Arrays.stream(Color.values()).map(c -> c.toAnsi()).max(Comparator.comparingInt(String::length)).get().length();
        int maxDescriptionLength = healthChecks.stream().map(check -> check.getDescription()).max(Comparator.comparingInt(String::length)).orElse("").length();
        int maxStatusLength = Arrays.stream(Status.values()).map(v -> v.name()).max(Comparator.comparingInt(String::length)).get().length() + maxColorLength + "\u001b[m".length() * 2 + Color.NoColor.toAnsi().length();
        String descFormat = String.format(DESCRIPTION_FORMAT, maxDescriptionLength);
        String statusFormat = String.format(STATUS_FORMAT, maxStatusLength);
        CompletableFuture future = this.healthCheckService.performAsyncHealthCheck(context, healthCheck -> System.out.print(String.format(descFormat, healthCheck.getDescription())), response -> {
            Status status = response.getStatus();
            Color statusColor = HealthCheckCommand.determineColor(status);
            String statusText = String.format(statusFormat, Colorizer.colorize(status.name(), statusColor));
            System.out.print(statusText);
            if (response.getMessage() != null) {
                System.out.print(" => " + response.getMessage());
            }
            System.out.println();
        });
        return future;
    }

    private static Color determineColor(Status status) {
        switch (status) {
            case Failure: {
                return Color.Red;
            }
            case Timeout: {
                return Color.Yellow;
            }
            case Starting: {
                return Color.Blue;
            }
            case Success: {
                return Color.Green;
            }
            case Unknown: {
                return Color.Yellow;
            }
        }
        return Color.NoColor;
    }
}

