/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CassandraPoolConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPoolConfiguration.class);

    @Bean(name={"cassandra.pool.core-connections-per-host"})
    public Integer getCoreConnectionsPerHost() {
        return CassandraPoolConfiguration.sysPropToIntOrNull("org.opennms.newts.config.core-connections-per-host");
    }

    @Bean(name={"cassandra.pool.max-connections-per-host"})
    public Integer getMaxConnectionsPerHost() {
        return CassandraPoolConfiguration.sysPropToIntOrNull("org.opennms.newts.config.max-connections-per-host");
    }

    @Bean(name={"cassandra.pool.max-requests-per-connection"})
    public Integer getMaxRequestsPerConnection() {
        return CassandraPoolConfiguration.sysPropToIntOrNull("org.opennms.newts.config.max-requests-per-connection");
    }

    private static Integer sysPropToIntOrNull(String sysProp) {
        String val = System.getProperty(sysProp, null);
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse value of system property {}='{}' to an integer. Using default value.", (Object)sysProp, (Object)val);
            return null;
        }
    }
}

