/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.support;

import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.netmgt.newts.support.GuavaSearchableResourceMetadataCache;
import org.opennms.newts.api.Context;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.search.CassandraCachePrimer;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CachePrimer
implements InitializingBean,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CachePrimer.class);
    @Autowired(required=false)
    private GuavaSearchableResourceMetadataCache resourceMetadataCache;
    @Autowired
    private CassandraSession session;
    @Autowired
    private Context context;
    private final boolean primingDisabled;
    private final long blockWhilePrimingMs;
    private final int fetchSize;
    private final int fetchMoreThreshold;

    @Inject
    public CachePrimer(@Named(value="cache.priming.disable") boolean primingDisabled, @Named(value="cache.priming.block_ms") long blockWhilePrimingMs, @Named(value="cache.priming.fetch_size") int fetchSize, @Named(value="cache.priming.fetch_more_threshold") int fetchMoreThreshold) {
        this.primingDisabled = primingDisabled;
        this.blockWhilePrimingMs = blockWhilePrimingMs;
        this.fetchSize = fetchSize;
        this.fetchMoreThreshold = fetchMoreThreshold;
    }

    public void afterPropertiesSet() {
        if (!this.primingDisabled) {
            LOG.debug("Cache priming disabled. Skipping cache priming.");
            return;
        }
        if (this.resourceMetadataCache == null) {
            LOG.debug("Resource meta-data cache is not of type {}. Skipping cache priming.", (Object)GuavaSearchableResourceMetadataCache.class.getCanonicalName());
            return;
        }
        Thread thread = new Thread(this);
        thread.setName("Newts-CachePrimer");
        thread.start();
        if (this.blockWhilePrimingMs >= 0L) {
            try {
                if (this.blockWhilePrimingMs == 0L) {
                    LOG.info("Blocking startup while waiting for cache to be fully primed.");
                } else {
                    LOG.info("Blocking startup for up-to {}ms while waiting for cache to be primed.", (Object)this.blockWhilePrimingMs);
                }
                thread.join(this.blockWhilePrimingMs);
                if (thread.isAlive()) {
                    LOG.info("Cache is not yet done priming after waiting for {}ms. Current size is: {}. The operation will continue in the background.", (Object)this.blockWhilePrimingMs, (Object)this.resourceMetadataCache.getSize());
                }
            }
            catch (InterruptedException e) {
                LOG.info("Thread was interrupted while waiting for the cache to be primed.");
            }
        }
    }

    @Override
    public void run() {
        CassandraCachePrimer primer = new CassandraCachePrimer(this.session);
        primer.setFetchSize(this.fetchSize);
        primer.setFetchMoreThreshold(this.fetchMoreThreshold);
        LOG.info("Starting to prime the cache.");
        primer.prime((ResourceMetadataCache)this.resourceMetadataCache, this.context);
        LOG.info("Done priming cache. Cache size: {}", (Object)this.resourceMetadataCache.getSize());
    }

    public void setResourceMetadataCache(GuavaSearchableResourceMetadataCache resourceMetadataCache) {
        this.resourceMetadataCache = resourceMetadataCache;
    }

    public void setSession(CassandraSession session) {
        this.session = session;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

