/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.core;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.core.DefaultCollectionAgentService;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.transaction.support.TransactionOperations;

public class OsgiCollectionAgentFactory
implements CollectionAgentFactory {
    private static boolean storeByForeignSource = Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    private NodeDao nodeDao;
    private IpInterfaceDao ipInterfaceDao;
    private TransactionOperations transactionOperations;

    public OsgiCollectionAgentFactory(NodeDao nodeDao, IpInterfaceDao ipInterfaceDao, TransactionOperations transactionOperations) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
    }

    public CollectionAgent createCollectionAgent(OnmsIpInterface ipIf) {
        return (CollectionAgent)this.transactionOperations.execute(status -> {
            OnmsNode node = ipIf.getNode();
            if (node.getLocation() != null) {
                return this.createAgent(ipIf, node, node.getLocation().getLocationName());
            }
            return this.createAgent(ipIf, node, null);
        });
    }

    public CollectionAgent createCollectionAgent(String nodeCriteria, InetAddress ipAddr) {
        return (CollectionAgent)this.transactionOperations.execute(status -> {
            OnmsNode node = this.lookupNode(nodeCriteria);
            OnmsIpInterface ipInterface = this.lookupIpInterface(node, InetAddressUtils.str((InetAddress)ipAddr));
            CollectionAgent agent = this.createAgent(ipInterface, node, node.getLocation() != null ? node.getLocation().getLocationName() : null);
            return agent;
        });
    }

    public CollectionAgent createCollectionAgentAndOverrideLocation(String nodeCriteria, InetAddress ipAddr, String location) {
        return (CollectionAgent)this.transactionOperations.execute(status -> {
            OnmsNode node = this.lookupNode(nodeCriteria);
            OnmsIpInterface ipInterface = this.lookupIpInterface(node, InetAddressUtils.str((InetAddress)ipAddr));
            CollectionAgent agent = this.createAgent(ipInterface, node, location);
            return agent;
        });
    }

    private CollectionAgent createAgent(OnmsIpInterface ipIf, OnmsNode node, String location) {
        CollectionAgentDTO agent = new CollectionAgentDTO();
        agent.setAddress(ipIf.getIpAddress());
        agent.setForeignId(node.getForeignId());
        agent.setForeignSource(node.getForeignSource());
        agent.setNodeId(node.getId().intValue());
        agent.setNodeLabel(node.getLabel());
        agent.setLocationName(location);
        agent.setStorageResourcePath(DefaultCollectionAgentService.createStorageResourcePath((CollectionAgent)agent));
        agent.setStoreByForeignSource(Boolean.valueOf(storeByForeignSource));
        return agent;
    }

    private OnmsNode lookupNode(String nodeCriteria) {
        OnmsNode node = this.nodeDao.get(nodeCriteria);
        if (node == null) {
            throw new IllegalArgumentException(String.format("No node found with lookup criteria: %s", nodeCriteria));
        }
        return node;
    }

    private OnmsIpInterface lookupIpInterface(OnmsNode node, String ipAddress) {
        OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(node.getId(), ipAddress);
        if (ipInterface == null) {
            throw new IllegalArgumentException(String.format("No interface found with IP %s on node %s", ipAddress, node.getId()));
        }
        return ipInterface;
    }
}

