/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableMetaData;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableIpInterface
implements IpInterface {
    private final InetAddress ipAddress;
    private final Optional<SnmpInterface> snmpInterface;
    private final List<MetaData> metaData;

    private ImmutableIpInterface(InetAddress ipAddress, SnmpInterface snmpInterface, List<MetaData> metaData) {
        this.ipAddress = ipAddress;
        this.snmpInterface = Optional.ofNullable(snmpInterface);
        this.metaData = ImmutableCollections.with(ImmutableMetaData::immutableCopy).newList(metaData);
    }

    public static ImmutableIpInterface newInstance(InetAddress ipAddress, SnmpInterface snmpInterface, List<MetaData> metaData) {
        return new ImmutableIpInterface(Objects.requireNonNull(ipAddress), snmpInterface, metaData);
    }

    public static IpInterface immutableCopy(IpInterface ipInterface) {
        if (ipInterface == null || ipInterface instanceof ImmutableIpInterface) {
            return ipInterface;
        }
        return ImmutableIpInterface.newInstance(ipInterface.getIpAddress(), ipInterface.getSnmpInterface().orElse(null), ipInterface.getMetaData());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IpInterface ipInterface) {
        return new Builder(ipInterface);
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public Optional<SnmpInterface> getSnmpInterface() {
        return this.snmpInterface;
    }

    public List<MetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableIpInterface that = (ImmutableIpInterface)o;
        return Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.snmpInterface, that.snmpInterface) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.snmpInterface, this.metaData);
    }

    public String toString() {
        return "ImmutableIpInterface{ipAddress=" + this.ipAddress + ", snmpInterface=" + this.snmpInterface + ", metaData=" + this.metaData + '}';
    }

    public static final class Builder {
        private InetAddress ipAddress;
        private SnmpInterface snmpInterface;
        private List<MetaData> metaData;

        private Builder() {
        }

        private Builder(IpInterface ipInterface) {
            this.ipAddress = ipInterface.getIpAddress();
            this.metaData = MutableCollections.copyListFromNullable(ipInterface.getMetaData(), LinkedList::new);
        }

        public Builder setIpAddress(InetAddress ipAddress) {
            this.ipAddress = Objects.requireNonNull(ipAddress);
            return this;
        }

        public Builder setSnmpInterface(SnmpInterface snmpInterface) {
            this.snmpInterface = snmpInterface;
            return this;
        }

        public Builder setMetaData(List<MetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(MetaData metaData) {
            if (this.metaData == null) {
                this.metaData = new LinkedList<MetaData>();
            }
            this.metaData.add(metaData);
            return this;
        }

        public ImmutableIpInterface build() {
            return ImmutableIpInterface.newInstance(this.ipAddress, this.snmpInterface, this.metaData);
        }
    }
}

