/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.clazzification.shell;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.persistence.api.Group;

@Command(scope="opennms-classification", name="list-groups", description="Lists all classification groups stored in the database")
@Service
public class ClassificationListGroupCommand
implements Action {
    @Reference
    private ClassificationService classificationService;

    public Object execute() throws Exception {
        Criteria criteria = new CriteriaBuilder(Group.class).orderBy("position", true).toCriteria();
        List groups = this.classificationService.findMatchingGroups(criteria);
        String TEMPLATE = "%4s   %4s   %-20s   %-50s   %-8s   %-8s";
        if (!groups.isEmpty()) {
            System.out.println(String.format("%4s   %4s   %-20s   %-50s   %-8s   %-8s", "ID", "Pos", "Name", "Description", "Editable", "Read-only"));
            for (Group group : groups) {
                System.out.println(String.format("%4s   %4s   %-20s   %-50s   %-8s   %-8s", group.getId(), group.getPosition(), group.getName(), group.getDescription(), group.isEnabled() ? "Y" : "N", group.isReadOnly() ? "Y" : "N"));
            }
            System.out.println();
        }
        System.out.println("=> " + groups.size() + " group(s) defined");
        return null;
    }
}

