/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.Scope;

public class ObjectScope<T>
implements Scope {
    private final T object;
    private final Map<ContextKey, Function<T, Optional<String>>> accessors = Maps.newHashMap();

    public ObjectScope(T object) {
        this.object = Objects.requireNonNull(object);
    }

    @Override
    public Optional<String> get(ContextKey contextKey) {
        return this.accessors.getOrDefault(contextKey, missing -> Optional.empty()).apply(this.object);
    }

    @Override
    public Set<ContextKey> keys() {
        return this.accessors.keySet();
    }

    public ObjectScope<T> map(String context, String key, Function<T, Optional<String>> accessor) {
        this.accessors.put(new ContextKey(context, key), accessor);
        return this;
    }
}

