/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.collect.ComparisonChain;
import java.util.Objects;

public final class ContextKey
implements Comparable<ContextKey> {
    public final String context;
    public final String key;

    public ContextKey(String context, String key) {
        this.context = Objects.requireNonNull(context);
        this.key = Objects.requireNonNull(key);
    }

    public ContextKey(String contextKey) {
        Objects.requireNonNull(contextKey, "contextKey must not be null");
        String[] arr = contextKey.split(":");
        if (arr.length != 2) {
            throw new IllegalArgumentException("contextKey '" + contextKey + "' must be in the format 'context:key'");
        }
        this.context = arr[0];
        this.key = arr[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextKey)) {
            return false;
        }
        ContextKey that = (ContextKey)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.key);
    }

    public String getContext() {
        return this.context;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(ContextKey that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.context), (Comparable)((Object)that.context)).compare((Comparable)((Object)this.key), (Comparable)((Object)that.key)).result();
    }
}

