/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdingSetImpl;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingVisitor;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingVisitorImpl
extends AbstractCollectionSetVisitor
implements ThresholdingVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingVisitor.class);
    final ThresholdingSetImpl m_thresholdingSet;
    final Map<String, CollectionAttribute> m_attributesMap = new HashMap<String, CollectionAttribute>();
    private Date m_collectionTimestamp;
    private ThresholdingEventProxy m_thresholdingEventProxy;
    private final Long m_sequenceNumber;

    protected ThresholdingVisitorImpl(ThresholdingSetImpl thresholdingSet, ResourceStorageDao resourceStorageDao, ThresholdingEventProxy eventProxy, Long sequenceNumber) {
        this.m_thresholdingSet = thresholdingSet;
        this.m_thresholdingEventProxy = eventProxy;
        this.m_collectionTimestamp = new Date();
        this.m_sequenceNumber = sequenceNumber;
    }

    public void setCounterReset(boolean counterReset) {
        this.m_thresholdingSet.setCounterReset(counterReset);
    }

    public boolean hasThresholds() {
        return this.m_thresholdingSet.hasThresholds();
    }

    @VisibleForTesting
    List<ThresholdGroup> getThresholdGroups() {
        return Collections.unmodifiableList(this.m_thresholdingSet.getThresholdGroups());
    }

    @VisibleForTesting
    List<String> getScheduledOutages() {
        return Collections.unmodifiableList(this.m_thresholdingSet.getscheduledOutages());
    }

    public void visitCollectionSet(CollectionSet set) {
        this.m_collectionTimestamp = set.getCollectionTimestamp();
    }

    public void reload() {
        this.m_thresholdingSet.reinitialize();
    }

    public void reloadScheduledOutages() throws ThresholdInitializationException {
        this.m_thresholdingSet.updateScheduledOutages();
    }

    public boolean isNodeInOutage() {
        return this.m_thresholdingSet.isNodeInOutage();
    }

    public void visitResource(CollectionResource resource) {
        this.m_attributesMap.clear();
    }

    public void visitAttribute(CollectionAttribute attribute) {
        if (this.m_thresholdingSet.hasThresholds(attribute)) {
            String name = attribute.getName();
            this.m_attributesMap.put(name, attribute);
            LOG.debug("visitAttribute: storing value {} for attribute named {}", attribute.getNumericValue() != null ? attribute.getNumericValue() : attribute.getStringValue(), (Object)name);
        }
    }

    public void completeResource(CollectionResource resource) {
        List<Event> eventList = this.m_thresholdingSet.applyThresholds(resource, this.m_attributesMap, this.m_collectionTimestamp, this.m_sequenceNumber);
        for (Event event : eventList) {
            this.m_thresholdingEventProxy.sendEvent(event);
        }
    }

    @VisibleForTesting
    public Date getCollectionTimestamp() {
        return this.m_collectionTimestamp;
    }

    public ThresholdingEventProxy getEventProxy() {
        return this.m_thresholdingEventProxy;
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.m_thresholdingEventProxy = eventProxy;
    }

    public String toString() {
        return "ThresholdingVisitor for " + this.m_thresholdingSet;
    }

    public int getNodeId() {
        return this.m_thresholdingSet.getNodeId();
    }
}

