/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.outages.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.impl.AbstractPollOutagesDao;
import org.opennms.netmgt.config.poller.outages.Outages;

public class OverrideablePollOutagesDaoImpl
extends AbstractPollOutagesDao
implements OverrideablePollOutagesDao {
    private Outages outagesConfig;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public synchronized void overrideConfig(InputStream config) {
        Objects.requireNonNull(config);
        try (InputStreamReader reader = new InputStreamReader(config);){
            this.overrideConfig((Outages)JaxbUtils.unmarshal(Outages.class, (Reader)reader));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void overrideConfig(Outages config) {
        this.outagesConfig = Objects.requireNonNull(config);
    }

    public Lock getReadLock() {
        return this.readWriteLock.readLock();
    }

    public Lock getWriteLock() {
        return this.readWriteLock.writeLock();
    }

    public void withWriteLock(Consumer<Outages> consumerWithLock) {
        this.getWriteLock().lock();
        try {
            consumerWithLock.accept(this.getReadOnlyConfig());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public void saveConfig() {
    }

    public void onConfigChanged() {
    }

    public synchronized Outages getReadOnlyConfig() {
        return this.outagesConfig;
    }

    public synchronized void reload() {
        if (this.outagesConfig == null) {
            this.outagesConfig = new Outages();
        }
    }
}

