/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd.shell;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.threshd.api.ThresholdStateMonitor;
import org.opennms.netmgt.threshd.shell.AbstractKeyOrIndexCommand;

@Command(scope="opennms-threshold-states", name="clear", description="Clears a specific threshold state")
@Service
public class Clear
extends AbstractKeyOrIndexCommand {
    @Reference
    ThresholdStateMonitor thresholdStateMonitor;
    @Option(name="-p", aliases={"--persisted-only"}, description="When set, clears only the persisted state")
    private boolean clearPersistedOnly;

    public Object execute() {
        String key = this.getKey();
        if (this.clearPersistedOnly) {
            this.blobStore.delete(key, "thresholding");
            return null;
        }
        this.thresholdStateMonitor.reinitializeState(key);
        return null;
    }
}

