/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.clazzification.shell;

import com.google.common.base.Strings;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.persistence.api.Protocol;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;
import org.opennms.netmgt.flows.clazzification.shell.ProtocolCompleter;

@Command(scope="opennms-classification", name="classify", description="Verify the classification rules by classifying a request, for example: opennms-classification:classify --protocol tcp --srcAddress 127.0.0.1 --srcPort 55000 --dstAddress 8.8.8.8 --destPort 22 --exporterAddress 127.0.0.1")
@Service
public class ClassificationClassifyCommand
implements Action {
    @Reference
    private ClassificationEngine classificationEngine;
    @Option(name="--protocol", description="Protocol", required=true)
    @Completion(value=ProtocolCompleter.class)
    private String protocol;
    @Option(name="--destAddress", aliases={"--dstAddress"}, description="Destination Address", required=true)
    private String dstAddress;
    @Option(name="--destPort", aliases={"--dstPort"}, description="Destination Port", required=true)
    private Integer dstPort;
    @Option(name="--exporterAddress", description="Exporter Address", required=true)
    private String exporterAddress;
    @Option(name="--srcAddress", description="Source Address", required=true)
    private String srcAddress;
    @Option(name="--srcPort", description="Source Port", required=true)
    private Integer srcPort;

    public Object execute() throws Exception {
        Protocol theProtocol = Protocols.getProtocol((String)this.protocol);
        if (theProtocol == null) {
            System.err.println("The provided protocol '" + this.protocol + "' is not supported");
            return null;
        }
        ClassificationRequest request = new ClassificationRequest();
        request.setProtocol(theProtocol);
        request.setDstAddress(this.dstAddress);
        request.setDstPort(this.dstPort);
        request.setExporterAddress(this.exporterAddress);
        request.setSrcAddress(this.srcAddress);
        request.setSrcPort(this.srcPort);
        String result = this.classificationEngine.classify(request);
        if (Strings.isNullOrEmpty((String)result)) {
            System.out.println("Unknown");
        } else {
            System.out.println(result);
        }
        return null;
    }
}

