/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.thresholding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.thresholding.Parameter;
import org.opennms.integration.api.xml.schema.thresholding.ServiceStatus;

@XmlRootElement(name="service")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Service
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="interval", required=true)
    private Long m_interval;
    @XmlAttribute(name="user-defined")
    private Boolean m_userDefined;
    @XmlAttribute(name="status")
    private ServiceStatus m_status;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Long getInterval() {
        return this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = ConfigUtils.assertNotNull(interval, "interval");
    }

    public Boolean getUserDefined() {
        return this.m_userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.m_userDefined = userDefined;
    }

    public Optional<ServiceStatus> getStatus() {
        return Optional.ofNullable(this.m_status);
    }

    public void setStatus(ServiceStatus status) {
        this.m_status = status;
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_name, this.m_interval, this.m_userDefined, this.m_status, this.m_parameters});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Service) {
            Service that = (Service)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(that.m_interval, that.m_interval) && Objects.equals(that.m_userDefined, that.m_userDefined) && Objects.equals((Object)that.m_status, (Object)that.m_status) && Objects.equals(that.m_parameters, that.m_parameters);
        }
        return false;
    }
}

