/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollerConfigFactory
extends PollerConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigFactory.class);
    private static PollerConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public PollerConfigFactory(long currentVersion, InputStream stream) {
        super(stream);
        this.m_currentVersion = currentVersion;
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream stream = null;
        PollerConfigFactory config = null;
        try {
            stream = new FileInputStream(cfgFile);
            config = new PollerConfigFactory(cfgFile.lastModified(), stream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        for (Package pollerPackage : config.getConfiguration().getPackages()) {
            for (Service service : pollerPackage.getServices()) {
                for (Parameter parm : service.getParameters()) {
                    if (!parm.getKey().equals("ds-name") || parm.getValue().length() <= 19) continue;
                    throw new IllegalStateException(String.format("ds-name '%s' in service '%s' (poller package '%s') is greater than %d characters", parm.getValue(), service.getName(), pollerPackage.getName(), 19));
                }
            }
        }
        PollerConfigFactory.setInstance(config);
    }

    public static synchronized void reload() throws IOException {
        PollerConfigFactory.init();
        PollerConfigFactory.getInstance().update();
    }

    public static synchronized PollerConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(PollerConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            this.getWriteLock().lock();
            try {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
                LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), StandardCharsets.UTF_8);
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws IOException {
        block5: {
            this.getWriteLock().lock();
            try {
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME);
                if (cfgFile.lastModified() <= this.m_currentVersion) break block5;
                this.m_currentVersion = cfgFile.lastModified();
                LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
                FileInputStream stream = null;
                InputStreamReader sr = null;
                try {
                    stream = new FileInputStream(cfgFile);
                    sr = new InputStreamReader(stream);
                    this.m_config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (Reader)sr);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sr);
                    IOUtils.closeQuietly((InputStream)stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)sr);
                IOUtils.closeQuietly((InputStream)stream);
                PollerConfigFactory.init();
                LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
        super.update();
    }
}

