/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.LldpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.LldpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class LldpTopologyServiceImpl
extends TopologyServiceImpl
implements LldpTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(LldpTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_lldpElementDao.deleteByNodeId(nodeid);
        this.m_lldpLinkDao.deleteByNodeId(nodeid);
        this.m_lldpElementDao.flush();
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        LldpElement element = this.m_lldpElementDao.findByNodeId(nodeId);
        if (element != null && element.getLldpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_lldpElementDao.delete(element);
            this.m_lldpElementDao.flush();
        }
        this.m_lldpLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void store(int nodeId, LldpLink link) {
        if (link == null) {
            return;
        }
        this.saveLldpLink(nodeId, link);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveLldpLink(final int nodeId, final LldpLink saveMe) {
        new UpsertTemplate<LldpLink, LldpLinkDao>(this.m_transactionManager, this.m_lldpLinkDao){

            @Override
            protected LldpLink query() {
                return ((LldpLinkDao)this.m_dao).get(nodeId, saveMe.getLldpLocalPortNum());
            }

            @Override
            protected LldpLink doUpdate(LldpLink dbLldpLink) {
                dbLldpLink.merge(saveMe);
                ((LldpLinkDao)this.m_dao).update(dbLldpLink);
                ((LldpLinkDao)this.m_dao).flush();
                return dbLldpLink;
            }

            @Override
            protected LldpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setLldpLinkLastPollTime(saveMe.getLldpLinkCreateTime());
                ((LldpLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((LldpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, LldpElement element) {
        if (element == null) {
            return;
        }
        LldpElement dbelement = this.m_lldpElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_lldpElementDao.saveOrUpdate(dbelement);
            this.m_lldpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
        this.m_lldpElementDao.saveOrUpdate(element);
        this.m_lldpElementDao.flush();
        this.updatesAvailable();
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    @Override
    public List<LldpElementTopologyEntity> findAllLldpElements() {
        return this.getTopologyEntityCache().getLldpElementTopologyEntities();
    }

    @Override
    public List<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> match() {
        ArrayList<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> results = new ArrayList<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>>();
        Map<Integer, LldpElementTopologyEntity> nodelldpelementidMap = this.getTopologyEntityCache().getLldpElementTopologyEntities().stream().collect(Collectors.toMap(lldpelem -> lldpelem.getNodeId(), lldpelem -> lldpelem));
        List<LldpLinkTopologyEntity> allLinks = this.getTopologyEntityCache().getLldpLinkTopologyEntities();
        HashMap<CompositeKey, LldpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, LldpLinkTopologyEntity>();
        for (LldpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getLldpRemChassisId(), nodelldpelementidMap.get(targetLink.getNodeId()).getLldpChassisId(), targetLink.getLldpPortId(), targetLink.getLldpPortIdSubType(), targetLink.getLldpRemPortId(), targetLink.getLldpRemPortIdSubType());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLinkTopologyEntity sourceLink : allLinks) {
            CompositeKey key;
            LldpLinkTopologyEntity targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            String sourceLldpChassisId = nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId();
            if (sourceLldpChassisId.equals(sourceLink.getLldpRemChassisId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getLldpLinks: self link not adding source: {}", (Object)sourceLink);
                }
                parsed.add(sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: source: {}", (Object)sourceLink);
            }
            if ((targetLink = (LldpLinkTopologyEntity)targetLinkMap.get(key = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpRemPortId(), sourceLink.getLldpRemPortIdSubType(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType()))) == null) {
                LOG.debug("getLldpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: lldp: {} target: {}", (Object)sourceLink.getLldpRemChassisId(), (Object)targetLink);
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyConnection.of(sourceLink, targetLink));
        }
        return results;
    }
}

