/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.clazzification.shell;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.exception.InvalidRuleException;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

@Command(scope="opennms-classification", name="list-invalid-rules", description="Lists invalid classification rules")
@Service
public class ClassificationListInvalidRuleCommand
implements Action {
    @Reference
    private ClassificationService classificationService;

    public Object execute() throws Exception {
        List<Rule> invalidRules = this.getInvalidRules();
        String TEMPLATE = "%-20s   %4s   %-20s   %-15s   %10s   %-40s   %-10s   %-40s   %-10s   %-20s   %-15s   %s";
        if (!invalidRules.isEmpty()) {
            System.out.println(String.format("%-20s   %4s   %-20s   %-15s   %10s   %-40s   %-10s   %-40s   %-10s   %-20s   %-15s   %s", "Group", "Pos", "Name", "Protocol", "ID", "Dest. Addr.", "Dest. Port", "Src. Addr.", "Src. Port", "Exporter Filter", "Bidirectional", "Error"));
            for (Rule rule : invalidRules) {
                String error = this.getErrorReason(rule);
                System.out.println(String.format("%-20s   %4s   %-20s   %-15s   %10s   %-40s   %-10s   %-40s   %-10s   %-20s   %-15s   %s", rule.getGroup().getName(), rule.getPosition(), rule.getName(), rule.getProtocol() == null ? "" : rule.getProtocol(), rule.getId(), rule.getDstAddress() == null ? "" : rule.getDstAddress(), rule.getDstPort() == null ? "" : rule.getDstPort(), rule.getSrcAddress() == null ? "" : rule.getSrcAddress(), rule.getSrcPort() == null ? "" : rule.getSrcPort(), rule.getExporterFilter() == null ? "" : rule.getExporterFilter(), rule.isOmnidirectional() ? "Y" : "N", error));
            }
            System.out.println();
        }
        System.out.println("=> " + invalidRules.size() + " invalid rule(s) found.");
        if (!invalidRules.isEmpty()) {
            System.out.println();
            System.out.println("Please manually fix these rules via the Flow Classification UI");
        }
        return null;
    }

    private List<Rule> getInvalidRules() {
        return this.classificationService.getInvalidRules().stream().sorted(Comparator.comparing(Rule::getGroupPosition).thenComparing(Rule::getPosition)).collect(Collectors.toList());
    }

    private String getErrorReason(Rule rule) {
        try {
            this.classificationService.validateRule(rule);
            return "Unknown";
        }
        catch (InvalidRuleException ex) {
            return ex.getMessage();
        }
    }
}

