/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.search.Indexer;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.ContextConfigurations;
import org.opennms.newts.cassandra.search.CassandraIndexingOptions;
import org.opennms.newts.cassandra.search.Constants;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;
import org.opennms.newts.cassandra.search.ResourceMetadata;
import org.opennms.newts.cassandra.search.ResourceMetadataCache;
import org.opennms.newts.cassandra.search.support.StatementGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIndexer
implements Indexer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraIndexer.class);
    private final CassandraSession m_session;
    private final int m_ttl;
    private final ResourceMetadataCache m_cache;
    private final Timer m_updateTimer;
    private final Timer m_deleteTimer;
    private final Meter m_inserts;
    private final ResourceIdSplitter m_resourceIdSplitter;
    private final ContextConfigurations m_contextConfigurations;
    private final PreparedStatement m_insertTermsStatement;
    private final CassandraIndexingOptions m_options;
    private final Set<StatementGenerator> statementsInFlight = Sets.newHashSet();

    @Inject
    public CassandraIndexer(CassandraSession session, @Named(value="search.cassandra.time-to-live") int ttl, ResourceMetadataCache cache, @Named(value="newtsMetricRegistry") MetricRegistry registry, CassandraIndexingOptions options, ResourceIdSplitter resourceIdSplitter, ContextConfigurations contextConfigurations) {
        this.m_session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"session argument");
        this.m_ttl = ttl;
        this.m_cache = (ResourceMetadataCache)Preconditions.checkNotNull((Object)cache, (Object)"cache argument");
        Preconditions.checkNotNull((Object)registry, (Object)"registry argument");
        this.m_options = (CassandraIndexingOptions)Preconditions.checkNotNull((Object)options, (Object)"options argument");
        this.m_resourceIdSplitter = (ResourceIdSplitter)Preconditions.checkNotNull((Object)resourceIdSplitter, (Object)"resourceIdSplitter argument");
        this.m_contextConfigurations = (ContextConfigurations)Preconditions.checkNotNull((Object)contextConfigurations, (Object)"contextConfigurations argument");
        this.m_updateTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"update"}));
        this.m_deleteTimer = registry.timer(MetricRegistry.name((String)"search", (String[])new String[]{"delete"}));
        this.m_inserts = registry.meter(MetricRegistry.name((String)"search", (String[])new String[]{"inserts"}));
        this.m_insertTermsStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"terms").value("context", (Object)QueryBuilder.bindMarker((String)"context")).value("resource", (Object)QueryBuilder.bindMarker((String)"resource")).value("field", (Object)QueryBuilder.bindMarker((String)"field")).value("value", (Object)QueryBuilder.bindMarker((String)"value")).using(QueryBuilder.ttl((int)ttl)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<Sample> samples) {
        Object object;
        Timer.Context ctx = this.m_updateTimer.time();
        HashSet generators = Sets.newHashSet();
        HashMap cacheQueue = Maps.newHashMap();
        for (Sample sample : samples) {
            this.maybeIndexResource(cacheQueue, generators, sample.getContext(), sample.getResource());
            this.maybeIndexResourceAttributes(cacheQueue, generators, sample.getContext(), sample.getResource());
            this.maybeAddMetricName(cacheQueue, generators, sample.getContext(), sample.getResource(), sample.getName());
        }
        try {
            if (!generators.isEmpty()) {
                object = this.statementsInFlight;
                synchronized (object) {
                    generators.removeAll(this.statementsInFlight);
                    this.statementsInFlight.addAll(generators);
                }
                this.m_inserts.mark((long)generators.size());
                ArrayList futures = Lists.newArrayList();
                for (Statement statementToExecute : this.toStatements(generators)) {
                    futures.add(this.m_session.executeAsync(statementToExecute));
                }
                for (ResultSetFuture future : futures) {
                    future.getUninterruptibly();
                }
            }
            for (Context context : cacheQueue.keySet()) {
                for (Map.Entry entry : ((Map)cacheQueue.get(context)).entrySet()) {
                    this.m_cache.merge(context, (Resource)entry.getKey(), (ResourceMetadata)entry.getValue());
                }
            }
        }
        finally {
            object = this.statementsInFlight;
            synchronized (object) {
                this.statementsInFlight.removeAll(generators);
            }
            ctx.stop();
        }
    }

    private List<Statement> toStatements(Set<StatementGenerator> generators) {
        ArrayList statementsToExecute = Lists.newArrayList();
        HashMap statementsByKey = Maps.newHashMap();
        for (StatementGenerator generator : generators) {
            Statement statement = generator.toStatement().setConsistencyLevel(this.m_contextConfigurations.getWriteConsistency(generator.getContext()));
            String key = generator.getKey();
            if (key == null) {
                statementsToExecute.add(statement);
                continue;
            }
            List statementsForKey = (List)statementsByKey.get(key);
            if (statementsForKey == null) {
                statementsForKey = Lists.newArrayList();
                statementsByKey.put(key, statementsForKey);
            }
            statementsForKey.add(statement);
        }
        for (List statementsForKey : statementsByKey.values()) {
            for (List partition : Lists.partition((List)statementsForKey, (int)this.m_options.getMaxBatchSize())) {
                statementsToExecute.add(QueryBuilder.unloggedBatch((RegularStatement[])partition.toArray(new RegularStatement[partition.size()])));
            }
        }
        return statementsToExecute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context context, Resource resource) {
        Timer.Context ctx = this.m_deleteTimer.time();
        ConsistencyLevel writeConsistency = this.m_contextConfigurations.getWriteConsistency(context);
        ArrayList statements = Lists.newArrayList();
        this.definitelyUnindexResource(statements, context, resource, writeConsistency);
        this.definitelyUnindexResourceAttributes(statements, context, resource, writeConsistency);
        this.definitelyRemoveMetricName(statements, context, resource, writeConsistency);
        try {
            if (!statements.isEmpty()) {
                this.m_session.execute((Statement)QueryBuilder.batch((RegularStatement[])statements.toArray(new RegularStatement[statements.size()])));
            }
            this.m_cache.delete(context, resource);
        }
        finally {
            ctx.stop();
        }
    }

    private void recursivelyIndexResourceElements(Set<StatementGenerator> generators, Context context, String resourceId) {
        List<String> elements = this.m_resourceIdSplitter.splitIdIntoElements(resourceId);
        int numElements = elements.size();
        if (numElements == 1) {
            generators.add(new TermInsert(context, resourceId, "_parent", "_root"));
        } else {
            String parentResourceId = this.m_resourceIdSplitter.joinElementsToId(elements.subList(0, numElements - 1));
            generators.add(new TermInsert(context, resourceId, "_parent", parentResourceId));
            this.recursivelyIndexResourceElements(generators, context, parentResourceId);
        }
    }

    private void maybeIndexResource(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, Set<StatementGenerator> generators, Context context, Resource resource) {
        if (!this.m_cache.get(context, resource).isPresent()) {
            LOG.trace("Resource '{}' in context '{}' is not present is cache.", (Object)resource, (Object)context);
            if (this.m_options.shouldIndexResourceTerms()) {
                for (String s : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
                    generators.add(new TermInsert(context, resource.getId(), Constants.DEFAULT_TERM_FIELD, s));
                }
            }
            if (this.m_options.isHierarchicalIndexingEnabled()) {
                this.recursivelyIndexResourceElements(generators, context, resource.getId());
            }
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue);
        }
    }

    private void recursivelyUnindexResourceElements(List<RegularStatement> statement, Context context, String resourceId, ConsistencyLevel writeConsistencyLevel) {
        List<String> elements = this.m_resourceIdSplitter.splitIdIntoElements(resourceId);
        int numElements = elements.size();
        if (numElements == 1) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)"_parent")).and(QueryBuilder.eq((String)"value", (Object)"_root")).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
        } else {
            String parentResourceId = this.m_resourceIdSplitter.joinElementsToId(elements.subList(0, numElements - 1));
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)"_parent")).and(QueryBuilder.eq((String)"value", (Object)parentResourceId)).and(QueryBuilder.eq((String)"resource", (Object)resourceId));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
            this.recursivelyUnindexResourceElements(statement, context, parentResourceId, writeConsistencyLevel);
        }
    }

    private void definitelyUnindexResource(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistencyLevel) {
        for (String s : this.m_resourceIdSplitter.splitIdIntoElements(resource.getId())) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)Constants.DEFAULT_TERM_FIELD)).and(QueryBuilder.eq((String)"value", (Object)s)).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistencyLevel);
            statement.add((RegularStatement)delete);
        }
        if (this.m_options.isHierarchicalIndexingEnabled()) {
            this.recursivelyUnindexResourceElements(statement, context, resource.getId(), writeConsistencyLevel);
        }
    }

    private void maybeIndexResourceAttributes(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, Set<StatementGenerator> generators, Context context, Resource resource) {
        if (!resource.getAttributes().isPresent()) {
            return;
        }
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        for (Map.Entry field : ((Map)resource.getAttributes().get()).entrySet()) {
            if (cached.isPresent() && ((ResourceMetadata)cached.get()).containsAttribute((String)field.getKey(), (String)field.getValue())) continue;
            LOG.trace("Resource attribute for resource '{}' in context '{}' for entry '{}' is not present is cache. Cached meta-data is: {}", new Object[]{resource, context, field, cached});
            if (this.m_options.shouldIndexUsingDefaultTerm()) {
                generators.add(new TermInsert(context, resource.getId(), Constants.DEFAULT_TERM_FIELD, (String)field.getValue()));
            }
            generators.add(new TermInsert(context, resource.getId(), (String)field.getKey(), (String)field.getValue()));
            generators.add(new AttributeInsert(context, resource.getId(), (String)field.getKey(), (String)field.getValue()));
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putAttribute((String)field.getKey(), (String)field.getValue());
        }
    }

    private void definitelyUnindexResourceAttributes(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistency) {
        if (!resource.getAttributes().isPresent()) {
            return;
        }
        for (Map.Entry field : ((Map)resource.getAttributes().get()).entrySet()) {
            Delete.Where delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", (Object)Constants.DEFAULT_TERM_FIELD)).and(QueryBuilder.eq((String)"value", field.getValue())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
            delete = QueryBuilder.delete().from("terms").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"field", field.getKey())).and(QueryBuilder.eq((String)"value", field.getValue())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
            delete = QueryBuilder.delete().from("resource_attributes").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId())).and(QueryBuilder.eq((String)"attribute", field.getKey()));
            delete.setConsistencyLevel(writeConsistency);
            statement.add((RegularStatement)delete);
        }
    }

    private void maybeAddMetricName(Map<Context, Map<Resource, ResourceMetadata>> cacheQueue, Set<StatementGenerator> generators, Context context, Resource resource, String name) {
        Optional<ResourceMetadata> cached = this.m_cache.get(context, resource);
        if (!cached.isPresent() || !((ResourceMetadata)cached.get()).containsMetric(name)) {
            LOG.trace("Metric resource '{}' in context '{}' with name '{}' is not present is cache. Cached meta-data is: {}", new Object[]{resource, context, name, cached});
            generators.add(new MetricInsert(context, resource.getId(), name));
            CassandraIndexer.getOrCreateResourceMetadata(context, resource, cacheQueue).putMetric(name);
        }
    }

    private void definitelyRemoveMetricName(List<RegularStatement> statement, Context context, Resource resource, ConsistencyLevel writeConsistency) {
        Delete.Where delete = QueryBuilder.delete().from("resource_metrics").where(QueryBuilder.eq((String)"context", (Object)context.getId())).and(QueryBuilder.eq((String)"resource", (Object)resource.getId()));
        delete.setConsistencyLevel(writeConsistency);
        statement.add((RegularStatement)delete);
    }

    private static ResourceMetadata getOrCreateResourceMetadata(Context context, Resource resource, Map<Context, Map<Resource, ResourceMetadata>> map) {
        ResourceMetadata rMeta;
        HashMap inner = map.get(context);
        if (inner == null) {
            inner = Maps.newHashMap();
            map.put(context, inner);
        }
        if ((rMeta = (ResourceMetadata)inner.get(resource)) == null) {
            rMeta = new ResourceMetadata();
            inner.put(resource, rMeta);
        }
        return rMeta;
    }

    private class AttributeInsert
    extends KeyValuePairInsert {
        public AttributeInsert(Context context, String resourceId, String field, String value) {
            super(context, resourceId, field, value);
        }

        @Override
        public String getKey() {
            return String.format("(ATTRS,%s,%s)", this.m_context.getId(), this.m_resourceId);
        }

        public RegularStatement toStatement() {
            LOG.trace("Inserting attribute in context: '{}' with resource id: '{}' with name: '{}' and value: '{}'", new Object[]{this.m_context, this.m_resourceId, this.m_field, this.m_value});
            return QueryBuilder.insertInto((String)"resource_attributes").value("context", (Object)this.m_context.getId()).value("resource", (Object)this.m_resourceId).value("attribute", (Object)this.m_field).value("value", (Object)this.m_value).using(QueryBuilder.ttl((int)CassandraIndexer.this.m_ttl));
        }
    }

    private class TermInsert
    extends KeyValuePairInsert {
        public TermInsert(Context context, String resourceId, String field, String value) {
            super(context, resourceId, field, value);
        }

        @Override
        public String getKey() {
            return null;
        }

        public BoundStatement toStatement() {
            LOG.trace("Inserting term in context: '{}' with resource id: '{}' with field: '{}' and value: '{}'", new Object[]{this.m_context, this.m_resourceId, this.m_field, this.m_value});
            return CassandraIndexer.this.m_insertTermsStatement.bind().setString("context", this.m_context.getId()).setString("resource", this.m_resourceId).setString("field", this.m_field).setString("value", this.m_value);
        }
    }

    private static abstract class KeyValuePairInsert
    implements StatementGenerator {
        protected final Context m_context;
        protected final String m_resourceId;
        protected final String m_field;
        protected final String m_value;

        public KeyValuePairInsert(Context context, String resourceId, String field, String value) {
            this.m_context = Objects.requireNonNull(context);
            this.m_resourceId = Objects.requireNonNull(resourceId);
            this.m_field = Objects.requireNonNull(field);
            this.m_value = Objects.requireNonNull(value);
        }

        @Override
        public Context getContext() {
            return this.m_context;
        }

        public int hashCode() {
            return Objects.hash(this.m_context, this.m_resourceId, this.m_field, this.m_value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyValuePairInsert other = (KeyValuePairInsert)obj;
            return Objects.equals(this.m_context, other.m_context) && Objects.equals(this.m_resourceId, other.m_resourceId) && Objects.equals(this.m_field, other.m_field) && Objects.equals(this.m_value, other.m_value);
        }
    }

    private class MetricInsert
    implements StatementGenerator {
        private final Context m_context;
        private final String m_resourceId;
        private final String m_metric;

        public MetricInsert(Context context, String resourceId, String metric) {
            this.m_context = Objects.requireNonNull(context);
            this.m_resourceId = Objects.requireNonNull(resourceId);
            this.m_metric = Objects.requireNonNull(metric);
        }

        @Override
        public String getKey() {
            return String.format("(METRICS,%s,%s)", this.m_context.getId(), this.m_resourceId);
        }

        public RegularStatement toStatement() {
            LOG.trace("Inserting metric in context: '{}' with resource id: '{}' with name: '{}'", new Object[]{this.m_context, this.m_resourceId, this.m_metric});
            return QueryBuilder.insertInto((String)"resource_metrics").value("context", (Object)this.m_context.getId()).value("resource", (Object)this.m_resourceId).value("metric_name", (Object)this.m_metric).using(QueryBuilder.ttl((int)CassandraIndexer.this.m_ttl));
        }

        @Override
        public Context getContext() {
            return this.m_context;
        }

        public int hashCode() {
            return Objects.hash(this.m_context, this.m_resourceId, this.m_metric);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetricInsert other = (MetricInsert)obj;
            return Objects.equals(this.m_context, other.m_context) && Objects.equals(this.m_resourceId, other.m_resourceId) && Objects.equals(this.m_metric, other.m_metric);
        }
    }
}

