/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.server;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.OnmsKafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.common.AbstractMessageConsumerManager;
import org.opennms.core.ipc.sink.model.SinkMessageProtos;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.distributed.core.api.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class KafkaMessageConsumerManager
extends AbstractMessageConsumerManager
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaMessageConsumerManager.class);
    private final Map<SinkModule<?, Message>, List<KafkaConsumerRunner>> consumerRunnersByModule = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("kafka-consumer-%d").build();
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private final Properties kafkaConfig = new Properties();
    private final KafkaConfigProvider configProvider;
    private Cache<String, ByteString> largeMessageCache;
    private Cache<String, Integer> currentChunkCache;
    private MetricRegistry metricRegistry;
    private JmxReporter jmxReporter;
    @Autowired
    private TracerRegistry tracerRegistry;
    @Autowired
    private Identity identity;

    public KafkaMessageConsumerManager() {
        this((KafkaConfigProvider)new OnmsKafkaConfigProvider("org.opennms.core.ipc.sink.kafka."));
    }

    public KafkaMessageConsumerManager(KafkaConfigProvider configProvider, Identity identity, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.identity = identity;
        this.tracerRegistry = tracerRegistry;
        this.metricRegistry = metricRegistry;
    }

    public KafkaMessageConsumerManager(KafkaConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider);
    }

    protected void startConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (!this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Starting consumers for module: {}", module);
            int numConsumerThreads = KafkaMessageConsumerManager.getNumConsumerThreads(module);
            ArrayList<KafkaConsumerRunner> consumerRunners = new ArrayList<KafkaConsumerRunner>(numConsumerThreads);
            for (int i = 0; i < numConsumerThreads; ++i) {
                KafkaConsumerRunner consumerRunner = new KafkaConsumerRunner(module);
                this.executor.execute(consumerRunner);
                consumerRunners.add(new KafkaConsumerRunner(module));
            }
            this.consumerRunnersByModule.put(module, consumerRunners);
        }
    }

    protected void stopConsumingForModule(SinkModule<?, Message> module) throws Exception {
        if (this.consumerRunnersByModule.containsKey(module)) {
            LOG.info("Stopping consumers for module: {}", module);
            List<KafkaConsumerRunner> consumerRunners = this.consumerRunnersByModule.get(module);
            for (KafkaConsumerRunner consumerRunner : consumerRunners) {
                consumerRunner.shutdown();
            }
            this.consumerRunnersByModule.remove(module);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.kafkaConfig.clear();
        this.kafkaConfig.put("enable.auto.commit", "true");
        this.kafkaConfig.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("auto.commit.interval.ms", "1000");
        this.kafkaConfig.putAll((Map<?, ?>)this.configProvider.getProperties());
        LOG.info("KafkaMessageConsumerManager: consuming from Kafka using: {}", (Object)this.kafkaConfig);
        String cacheConfig = this.kafkaConfig.getProperty("messageId.cache.config", "maximumSize=1000,expireAfterWrite=10m");
        this.largeMessageCache = CacheBuilder.from((String)cacheConfig).build();
        this.currentChunkCache = CacheBuilder.from((String)cacheConfig).build();
        if (this.identity != null && this.tracerRegistry != null) {
            this.tracerRegistry.init(this.identity.getId());
        }
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.getMetricRegistry()).inDomain("org.opennms.core.ipc.sink.consumer").build();
        this.jmxReporter.start();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public Tracer getTracer() {
        if (this.tracerRegistry != null) {
            return this.tracerRegistry.getTracer();
        }
        return GlobalTracer.get();
    }

    public MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
        }
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private class KafkaConsumerRunner
    implements Runnable {
        private final SinkModule<?, Message> module;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final KafkaConsumer<String, byte[]> consumer;
        private final String topic;
        private Histogram messageSize;
        private Timer dispatchTime;

        public KafkaConsumerRunner(SinkModule<?, Message> module) {
            this.module = module;
            JmsQueueNameFactory topicNameFactory = new JmsQueueNameFactory("Sink", module.getId());
            this.topic = topicNameFactory.getName();
            this.consumer = (KafkaConsumer)Utils.runWithGivenClassLoader(() -> new KafkaConsumer(KafkaMessageConsumerManager.this.kafkaConfig), (ClassLoader)KafkaConsumer.class.getClassLoader());
            this.messageSize = KafkaMessageConsumerManager.this.getMetricRegistry().histogram(MetricRegistry.name((String)module.getId(), (String[])new String[]{"messageSize"}));
            this.dispatchTime = KafkaMessageConsumerManager.this.getMetricRegistry().timer(MetricRegistry.name((String)module.getId(), (String[])new String[]{"dispatchTime"}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logging.putPrefix((String)"ipc");
            try {
                this.consumer.subscribe(Arrays.asList(this.topic));
                while (!this.closed.get()) {
                    ConsumerRecords records = this.consumer.poll(100L);
                    for (ConsumerRecord record : records) {
                        try {
                            SinkMessageProtos.SinkMessage sinkMessage = SinkMessageProtos.SinkMessage.parseFrom((byte[])((byte[])record.value()));
                            byte[] messageInBytes = sinkMessage.getContent().toByteArray();
                            String messageId = sinkMessage.getMessageId();
                            if (sinkMessage.getTotalChunks() > 1) {
                                Integer chunkNum;
                                if (KafkaMessageConsumerManager.this.largeMessageCache == null || KafkaMessageConsumerManager.this.currentChunkCache == null) {
                                    LOG.error("LargeMessageCache config {}={} is invalid", (Object)"messageId.cache.config", (Object)KafkaMessageConsumerManager.this.kafkaConfig.getProperty("messageId.cache.config"));
                                    continue;
                                }
                                if (KafkaMessageConsumerManager.this.currentChunkCache.getIfPresent((Object)messageId) == null) {
                                    KafkaMessageConsumerManager.this.currentChunkCache.put((Object)messageId, (Object)0);
                                }
                                if ((chunkNum = (Integer)KafkaMessageConsumerManager.this.currentChunkCache.getIfPresent((Object)messageId)) != null && chunkNum.intValue() == sinkMessage.getCurrentChunkNumber()) continue;
                                ByteString byteString = (ByteString)KafkaMessageConsumerManager.this.largeMessageCache.getIfPresent((Object)messageId);
                                if (byteString != null) {
                                    KafkaMessageConsumerManager.this.largeMessageCache.put((Object)messageId, (Object)byteString.concat(sinkMessage.getContent()));
                                } else {
                                    KafkaMessageConsumerManager.this.largeMessageCache.put((Object)messageId, (Object)sinkMessage.getContent());
                                }
                                chunkNum = chunkNum + 1;
                                KafkaMessageConsumerManager.this.currentChunkCache.put((Object)messageId, (Object)chunkNum);
                                if (sinkMessage.getTotalChunks() != chunkNum.intValue() || (byteString = (ByteString)KafkaMessageConsumerManager.this.largeMessageCache.getIfPresent((Object)messageId)) == null) continue;
                                messageInBytes = byteString.toByteArray();
                                KafkaMessageConsumerManager.this.largeMessageCache.invalidate((Object)messageId);
                                KafkaMessageConsumerManager.this.currentChunkCache.invalidate((Object)messageId);
                            }
                            this.messageSize.update(messageInBytes.length);
                            Tracer.SpanBuilder spanBuilder = this.buildSpanFromSinkMessage(sinkMessage);
                            Scope scope = spanBuilder.startActive(true);
                            Throwable throwable = null;
                            try {
                                Timer.Context context = this.dispatchTime.time();
                                Throwable throwable2 = null;
                                try {
                                    scope.span().setTag("messageSize", (Number)messageInBytes.length);
                                    scope.span().setTag("topic", this.topic);
                                    scope.span().setTag("thread", Thread.currentThread().getName());
                                    KafkaMessageConsumerManager.this.dispatch(this.module, this.module.unmarshal(messageInBytes));
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (context == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            context.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    context.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (scope == null) continue;
                                if (throwable != null) {
                                    try {
                                        scope.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                scope.close();
                            }
                        }
                        catch (RuntimeException e) {
                            LOG.warn("Unexpected exception while dispatching message", (Throwable)e);
                        }
                        catch (InvalidProtocolBufferException e) {
                            LOG.warn("Error parsing procotol buffer in message. The message will be dropped. \nEnsure that all components are running the same version of the software.");
                        }
                    }
                }
            }
            catch (WakeupException e) {
                if (!this.closed.get()) {
                    throw e;
                }
            }
            finally {
                this.consumer.close();
            }
        }

        private Tracer.SpanBuilder buildSpanFromSinkMessage(SinkMessageProtos.SinkMessage sinkMessage) {
            Tracer tracer = KafkaMessageConsumerManager.this.getTracer();
            HashMap tracingInfoMap = new HashMap();
            sinkMessage.getTracingInfoList().forEach(tracingInfo -> tracingInfoMap.put(tracingInfo.getKey(), tracingInfo.getValue()));
            SpanContext context = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapExtractAdapter(tracingInfoMap));
            Tracer.SpanBuilder spanBuilder = context != null ? tracer.buildSpan(this.module.getId()).addReference("follows_from", context) : tracer.buildSpan(this.module.getId());
            return spanBuilder;
        }

        public void shutdown() {
            this.closed.set(true);
            this.consumer.wakeup();
            if (KafkaMessageConsumerManager.this.jmxReporter != null) {
                KafkaMessageConsumerManager.this.jmxReporter.close();
            }
        }
    }
}

