/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.thresholding.PackageDefinition;
import org.opennms.integration.api.v1.config.thresholding.ServiceStatus;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.thresholding.ExcludeRange;
import org.opennms.integration.api.xml.schema.thresholding.Filter;
import org.opennms.integration.api.xml.schema.thresholding.IncludeRange;
import org.opennms.integration.api.xml.schema.thresholding.Package;
import org.opennms.integration.api.xml.schema.thresholding.Parameter;
import org.opennms.integration.api.xml.schema.thresholding.Service;
import org.opennms.integration.api.xml.schema.thresholding.ThreshdConfiguration;

public class ClasspathThreshdConfigurationLoader
extends ClasspathXmlLoader<ThreshdConfiguration> {
    public ClasspathThreshdConfigurationLoader(Class<?> clazz, String ... fileNames) {
        super(clazz, ThreshdConfiguration.class, "thresholding", fileNames);
    }

    public List<PackageDefinition> getPackages() {
        return this.getObjects().stream().flatMap(tc -> tc.getPackages().stream()).map(ClasspathThreshdConfigurationLoader::toPackageDefinition).collect(Collectors.toList());
    }

    private static PackageDefinition toPackageDefinition(final Package packageToConvert) {
        return new PackageDefinition(){
            private final org.opennms.integration.api.v1.config.thresholding.Filter filter;
            private final List<String> specifics;
            private final List<org.opennms.integration.api.v1.config.thresholding.IncludeRange> includeRanges;
            private final List<org.opennms.integration.api.v1.config.thresholding.ExcludeRange> excludeRanges;
            private final List<String> includedUrls;
            private final List<String> outageCalendars;
            private final List<org.opennms.integration.api.v1.config.thresholding.Service> services;
            {
                this.filter = ClasspathThreshdConfigurationLoader.toFilter(packageToConvert.getFilter());
                this.specifics = Collections.unmodifiableList(packageToConvert.getSpecifics());
                this.includeRanges = Collections.unmodifiableList(packageToConvert.getIncludeRanges().stream().map(x$0 -> ClasspathThreshdConfigurationLoader.toIncludeRange(x$0)).collect(Collectors.toList()));
                this.excludeRanges = Collections.unmodifiableList(packageToConvert.getExcludeRanges().stream().map(x$0 -> ClasspathThreshdConfigurationLoader.toExcludeRange(x$0)).collect(Collectors.toList()));
                this.includedUrls = Collections.unmodifiableList(packageToConvert.getIncludeUrls());
                this.outageCalendars = Collections.unmodifiableList(packageToConvert.getOutageCalendars());
                this.services = Collections.unmodifiableList(packageToConvert.getServices().stream().map(x$0 -> ClasspathThreshdConfigurationLoader.toService(x$0)).collect(Collectors.toList()));
            }

            public String getName() {
                return packageToConvert.getName();
            }

            public org.opennms.integration.api.v1.config.thresholding.Filter getFilter() {
                return this.filter;
            }

            public List<String> getSpecifics() {
                return this.specifics;
            }

            public List<org.opennms.integration.api.v1.config.thresholding.IncludeRange> getIncludeRanges() {
                return this.includeRanges;
            }

            public List<org.opennms.integration.api.v1.config.thresholding.ExcludeRange> getExcludeRanges() {
                return this.excludeRanges;
            }

            public List<String> getIncludeUrls() {
                return this.includedUrls;
            }

            public List<org.opennms.integration.api.v1.config.thresholding.Service> getServices() {
                return this.services;
            }

            public List<String> getOutageCalendars() {
                return this.outageCalendars;
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.Filter toFilter(final Filter filter) {
        return new org.opennms.integration.api.v1.config.thresholding.Filter(){

            public Optional<String> getContent() {
                return filter.getContent();
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.IncludeRange toIncludeRange(final IncludeRange includeRange) {
        return new org.opennms.integration.api.v1.config.thresholding.IncludeRange(){

            public String getBegin() {
                return includeRange.getBegin();
            }

            public String getEnd() {
                return includeRange.getEnd();
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.ExcludeRange toExcludeRange(final ExcludeRange excludeRange) {
        return new org.opennms.integration.api.v1.config.thresholding.ExcludeRange(){

            public String getBegin() {
                return excludeRange.getBegin();
            }

            public String getEnd() {
                return excludeRange.getEnd();
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.Service toService(final Service service) {
        return new org.opennms.integration.api.v1.config.thresholding.Service(){
            private final List<org.opennms.integration.api.v1.config.thresholding.Parameter> parameters;
            {
                this.parameters = Collections.unmodifiableList(service.getParameters().stream().map(x$0 -> ClasspathThreshdConfigurationLoader.toParameter(x$0)).collect(Collectors.toList()));
            }

            public String getName() {
                return service.getName();
            }

            public Long getInterval() {
                return service.getInterval();
            }

            public Boolean getUserDefined() {
                return service.getUserDefined();
            }

            public Optional<ServiceStatus> getStatus() {
                return service.getStatus().map(s -> ServiceStatus.valueOf((String)s.name()));
            }

            public List<org.opennms.integration.api.v1.config.thresholding.Parameter> getParameters() {
                return this.parameters;
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.Parameter toParameter(final Parameter parameter) {
        return new org.opennms.integration.api.v1.config.thresholding.Parameter(){

            public String getKey() {
                return parameter.getKey();
            }

            public String getValue() {
                return parameter.getValue();
            }
        };
    }
}

