/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dnsresolver.netty.NettyDnsResolver;

public class NettyDnsHealthCheck
implements HealthCheck {
    private final NettyDnsResolver dnsResolver;

    public NettyDnsHealthCheck(NettyDnsResolver dnsResolver) {
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
    }

    public String getDescription() {
        return "DNS Lookups (Netty)";
    }

    public Response perform(Context context) throws InterruptedException, ExecutionException, TimeoutException {
        String hostnameToLookup = "www.opennms.com";
        InetAddress ipAddressToReverseLookup = InetAddressUtils.getInetAddress((String)"1.1.1.1");
        CircuitBreaker.State cbState = this.dnsResolver.getCircuitBreaker().getState();
        if (!CircuitBreaker.State.CLOSED.equals((Object)cbState)) {
            return new Response(Status.Failure, "Expected circuit breaker to be CLOSED, but was: " + cbState);
        }
        Optional<InetAddress> addr = this.dnsResolver.lookup("www.opennms.com").get(context.getTimeout(), TimeUnit.SECONDS);
        if (!addr.isPresent()) {
            return new Response(Status.Failure, String.format("Lookup failed for '%s'. No A or AAAA records.", "www.opennms.com"));
        }
        Optional<String> hostname = this.dnsResolver.reverseLookup(ipAddressToReverseLookup).get(context.getTimeout(), TimeUnit.SECONDS);
        if (!hostname.isPresent()) {
            return new Response(Status.Failure, String.format("Reverse failed for '%s'. No PTR record.", ipAddressToReverseLookup));
        }
        return new Response(Status.Success, String.format("%s is at %s (cache %d/%d)", "www.opennms.com", addr.get().getHostAddress(), this.dnsResolver.getCache().getSize(), this.dnsResolver.getMaxCacheSize()));
    }
}

