/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import java.util.List;
import java.util.Objects;
import org.opennms.core.network.IPAddressRange;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpValue {
    private static final Logger LOG = LoggerFactory.getLogger(IpValue.class);
    private final List<IPAddressRange> ranges = Lists.newArrayList();

    public IpValue(String input) {
        this(new StringValue(input));
    }

    public IpValue(StringValue input) {
        Objects.requireNonNull(input);
        this.parse(input);
    }

    private void parse(StringValue input) {
        if (input.isNullOrEmpty()) {
            throw new IllegalArgumentException("input may not be null or empty");
        }
        List<StringValue> actualValues = input.splitBy(",");
        for (StringValue eachValue : actualValues) {
            if (eachValue.isRanged()) {
                List<StringValue> rangedValues = eachValue.splitBy("-");
                if (rangedValues.size() != 2) {
                    LOG.warn("Received multiple ranges {}. Will only use {}", rangedValues, rangedValues.subList(0, 2));
                }
                for (StringValue rangedValue : rangedValues) {
                    IpValue.verifyIpAddress(rangedValue);
                }
                IPAddressRange range = new IPAddressRange(rangedValues.get(0).getValue(), rangedValues.get(1).getValue());
                this.ranges.add(range);
                continue;
            }
            IpValue.verifyIpAddress(eachValue);
            this.ranges.add(new IPAddressRange(eachValue.getValue(), eachValue.getValue()));
        }
    }

    public boolean isInRange(String address) {
        return this.ranges.stream().anyMatch(r -> r.contains(address));
    }

    private static void verifyIpAddress(StringValue stringValue) {
        Objects.requireNonNull(stringValue);
        if (!InetAddresses.isInetAddress((String)stringValue.getValue())) {
            throw new IllegalArgumentException("Provided ip address '" + stringValue.getValue() + "' is invalid");
        }
    }
}

