/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationRuleProvider;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.classifier.Classifier;
import org.opennms.netmgt.flows.classification.internal.classifier.CombinedClassifier;
import org.opennms.netmgt.flows.classification.internal.value.PortValue;
import org.opennms.netmgt.flows.classification.persistence.api.DefaultRuleDefinition;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;
import org.opennms.netmgt.flows.classification.persistence.api.RulePositionComparator;
import org.slf4j.LoggerFactory;

public class DefaultClassificationEngine
implements ClassificationEngine {
    private final List<List<RuleDefinition>> rulePortList = new ArrayList<List<RuleDefinition>>(65536);
    private final Map<RuleDefinition, CombinedClassifier> ruleClassifierMap = new HashMap<RuleDefinition, CombinedClassifier>();
    private final LoadingCache<Integer, List<Classifier>> portClassifiersCache;
    private final Comparator<RuleDefinition> ruleComparator = new RulePositionComparator();
    private final ClassificationRuleProvider ruleProvider;
    private final List<Rule> invalidRules = Lists.newArrayList();
    private final FilterService filterService;

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, FilterService filterService) {
        this(ruleProvider, filterService, true);
    }

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, final FilterService filterService, boolean initialize) {
        this.ruleProvider = Objects.requireNonNull(ruleProvider);
        this.filterService = Objects.requireNonNull(filterService);
        this.portClassifiersCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, List<Classifier>>(){

            public List<Classifier> load(Integer port) throws Exception {
                List ruleDefinitions = (List)DefaultClassificationEngine.this.rulePortList.get(port);
                List<Classifier> classifiers = ruleDefinitions.stream().map(rule -> {
                    if (!DefaultClassificationEngine.this.ruleClassifierMap.containsKey(rule)) {
                        DefaultRuleDefinition portRule = new DefaultRuleDefinition();
                        portRule.setName(rule.getName());
                        portRule.setProtocol(rule.getProtocol());
                        portRule.setSrcAddress(rule.getSrcAddress());
                        portRule.setDstAddress(rule.getDstAddress());
                        portRule.setExporterFilter(rule.getExporterFilter());
                        portRule.setGroupPosition(rule.getGroupPosition());
                        portRule.setPosition(rule.getPosition());
                        if (rule.hasDstPortDefinition()) {
                            portRule.setDstPort(rule.getDstPort());
                        }
                        if (rule.hasSrcPortDefinition()) {
                            portRule.setSrcPort(rule.getSrcPort());
                        }
                        DefaultClassificationEngine.this.ruleClassifierMap.put(rule, new CombinedClassifier((RuleDefinition)portRule, filterService));
                    }
                    return (CombinedClassifier)DefaultClassificationEngine.this.ruleClassifierMap.get(rule);
                }).collect(Collectors.toList());
                return classifiers;
            }
        });
        if (initialize) {
            this.reload();
        }
    }

    private static RuleDefinition reverseRule(RuleDefinition rule) {
        DefaultRuleDefinition result = new DefaultRuleDefinition();
        result.setName(rule.getName());
        result.setDstAddress(rule.getSrcAddress());
        result.setDstPort(rule.getSrcPort());
        result.setSrcAddress(rule.getDstAddress());
        result.setSrcPort(rule.getDstPort());
        result.setProtocol(rule.getProtocol());
        result.setExporterFilter(rule.getExporterFilter());
        result.setGroupPosition(rule.getGroupPosition());
        return result;
    }

    public void reload() {
        int i;
        this.ruleClassifierMap.clear();
        this.rulePortList.clear();
        this.invalidRules.clear();
        this.portClassifiersCache.invalidateAll();
        ArrayList validRules = Lists.newArrayList();
        this.ruleProvider.getRules().forEach(rule -> {
            try {
                new CombinedClassifier((RuleDefinition)rule, this.filterService);
                validRules.add(rule);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Rule {} is not valid. Ignoring rule.", rule, (Object)ex);
                this.invalidRules.add((Rule)rule);
            }
        });
        List rules = validRules.stream().flatMap(rule -> rule.isOmnidirectional() && (rule.hasSrcPortDefinition() || rule.hasSrcAddressDefinition() || rule.hasDstPortDefinition() || rule.hasDstAddressDefinition()) ? Stream.of(rule, DefaultClassificationEngine.reverseRule((RuleDefinition)rule)) : Stream.of(rule)).collect(Collectors.toList());
        ArrayList<RuleDefinition> anyPortRules = new ArrayList<RuleDefinition>();
        for (int i2 = 0; i2 <= 65535; ++i2) {
            this.rulePortList.add(new ArrayList());
        }
        for (RuleDefinition ruleDefinition : rules) {
            if (ruleDefinition.hasSrcPortDefinition() && ruleDefinition.hasDstPortDefinition()) {
                for (Integer eachPort : new PortValue(ruleDefinition.getDstPort()).getPorts()) {
                    List<RuleDefinition> portRules = this.rulePortList.get(eachPort);
                    if (portRules.contains(ruleDefinition)) continue;
                    portRules.add(ruleDefinition);
                }
                continue;
            }
            if (ruleDefinition.hasSrcPortDefinition() || ruleDefinition.hasDstPortDefinition()) {
                PortValue portValue = new PortValue(ruleDefinition.hasDstPortDefinition() ? ruleDefinition.getDstPort() : ruleDefinition.getSrcPort());
                for (Integer eachPort : portValue.getPorts()) {
                    this.rulePortList.get(eachPort).add(ruleDefinition);
                }
                continue;
            }
            if (ruleDefinition.hasDstPortDefinition() || ruleDefinition.hasSrcPortDefinition()) continue;
            anyPortRules.add(ruleDefinition);
        }
        for (List list : this.rulePortList) {
            list.addAll(anyPortRules);
        }
        anyPortRules.clear();
        rules.clear();
        for (i = 0; i < this.rulePortList.size(); ++i) {
            List<RuleDefinition> list = this.rulePortList.get(i);
            list.sort(this.ruleComparator);
        }
        for (i = 0; i < this.rulePortList.size(); ++i) {
            this.getClassifiers(i);
        }
    }

    public List<Rule> getInvalidRules() {
        return Collections.unmodifiableList(this.invalidRules);
    }

    public String classify(ClassificationRequest classificationRequest) {
        Collection<Classifier> filteredClassifiers = this.getClassifiers(classificationRequest);
        Optional<String> first = filteredClassifiers.stream().map(classifier -> classifier.classify(classificationRequest)).filter(classifier -> classifier != null).findFirst();
        return first.orElse(null);
    }

    private Collection<Classifier> getClassifiers(ClassificationRequest request) {
        List<Classifier> srcPortClassifiers = this.getClassifiers(request.getSrcPort());
        List<Classifier> dstPortClassifiers = this.getClassifiers(request.getDstPort());
        if (srcPortClassifiers.isEmpty()) {
            return dstPortClassifiers;
        }
        if (dstPortClassifiers.isEmpty()) {
            return srcPortClassifiers;
        }
        if (Objects.equals(srcPortClassifiers, dstPortClassifiers)) {
            return dstPortClassifiers;
        }
        ArrayList<Classifier> classifiers = new ArrayList<Classifier>();
        classifiers.addAll(srcPortClassifiers);
        for (Classifier c : dstPortClassifiers) {
            if (classifiers.contains(c)) continue;
            classifiers.add(c);
        }
        Collections.sort(classifiers);
        return classifiers;
    }

    private List<Classifier> getClassifiers(int port) {
        try {
            return (List)this.portClassifiersCache.get((Object)port);
        }
        catch (ExecutionException ex) {
            throw Throwables.propagate((Throwable)ex.getCause());
        }
    }
}

