/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.predicate.PredicateCreator;
import java.time.Duration;
import java.util.function.Predicate;

public class CircuitBreakerConfig {
    public static final int DEFAULT_MAX_FAILURE_THRESHOLD = 50;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_RING_BUFFER_SIZE_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_RING_BUFFER_SIZE_IN_CLOSED_STATE = 100;
    private static final Predicate<Throwable> DEFAULT_RECORD_FAILURE_PREDICATE = throwable -> true;
    private Class<? extends Throwable>[] recordExceptions = new Class[0];
    private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
    private float failureRateThreshold = 50.0f;
    private int ringBufferSizeInHalfOpenState = 10;
    private int ringBufferSizeInClosedState = 100;
    private Duration waitDurationInOpenState = Duration.ofSeconds(60L);
    private Predicate<Throwable> recordFailurePredicate = DEFAULT_RECORD_FAILURE_PREDICATE;
    private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;

    private CircuitBreakerConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(CircuitBreakerConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static CircuitBreakerConfig ofDefaults() {
        return new Builder().build();
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public Duration getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public int getRingBufferSizeInHalfOpenState() {
        return this.ringBufferSizeInHalfOpenState;
    }

    public int getRingBufferSizeInClosedState() {
        return this.ringBufferSizeInClosedState;
    }

    public Predicate<Throwable> getRecordFailurePredicate() {
        return this.recordFailurePredicate;
    }

    public boolean isAutomaticTransitionFromOpenToHalfOpenEnabled() {
        return this.automaticTransitionFromOpenToHalfOpenEnabled;
    }

    static /* synthetic */ Class[] access$502(CircuitBreakerConfig x0, Class[] x1) {
        x0.recordExceptions = x1;
        return x1;
    }

    static /* synthetic */ Class[] access$402(CircuitBreakerConfig x0, Class[] x1) {
        x0.ignoreExceptions = x1;
        return x1;
    }

    public static class Builder {
        @Nullable
        private Predicate<Throwable> recordFailurePredicate;
        private Class<? extends Throwable>[] recordExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private float failureRateThreshold = 50.0f;
        private int ringBufferSizeInHalfOpenState = 10;
        private int ringBufferSizeInClosedState = 100;
        private Duration waitDurationInOpenState = Duration.ofSeconds(60L);
        private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;

        public Builder(CircuitBreakerConfig baseConfig) {
            this.waitDurationInOpenState = baseConfig.waitDurationInOpenState;
            this.ringBufferSizeInHalfOpenState = baseConfig.ringBufferSizeInHalfOpenState;
            this.ringBufferSizeInClosedState = baseConfig.ringBufferSizeInClosedState;
            this.failureRateThreshold = baseConfig.failureRateThreshold;
            this.ignoreExceptions = baseConfig.ignoreExceptions;
            this.recordExceptions = baseConfig.recordExceptions;
            this.recordFailurePredicate = baseConfig.recordFailurePredicate;
            this.automaticTransitionFromOpenToHalfOpenEnabled = baseConfig.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public Builder() {
        }

        public Builder failureRateThreshold(float failureRateThreshold) {
            if (failureRateThreshold <= 0.0f || failureRateThreshold > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        public Builder waitDurationInOpenState(Duration waitDurationInOpenState) {
            if (waitDurationInOpenState.toMillis() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 1[ms]");
            }
            this.waitDurationInOpenState = waitDurationInOpenState;
            return this;
        }

        public Builder ringBufferSizeInHalfOpenState(int ringBufferSizeInHalfOpenState) {
            if (ringBufferSizeInHalfOpenState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInHalfOpenState must be greater than 0");
            }
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        public Builder ringBufferSizeInClosedState(int ringBufferSizeInClosedState) {
            if (ringBufferSizeInClosedState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInClosedState must be greater than 0");
            }
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
            return this;
        }

        public Builder recordFailure(Predicate<Throwable> predicate) {
            this.recordFailurePredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder recordExceptions(Class<? extends Throwable> ... errorClasses) {
            this.recordExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public Builder enableAutomaticTransitionFromOpenToHalfOpen() {
            this.automaticTransitionFromOpenToHalfOpenEnabled = true;
            return this;
        }

        public Builder automaticTransitionFromOpenToHalfOpenEnabled(boolean enableAutomaticTransitionFromOpenToHalfOpen) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = enableAutomaticTransitionFromOpenToHalfOpen;
            return this;
        }

        public CircuitBreakerConfig build() {
            CircuitBreakerConfig config = new CircuitBreakerConfig();
            config.waitDurationInOpenState = this.waitDurationInOpenState;
            config.failureRateThreshold = this.failureRateThreshold;
            config.ringBufferSizeInClosedState = this.ringBufferSizeInClosedState;
            config.ringBufferSizeInHalfOpenState = this.ringBufferSizeInHalfOpenState;
            CircuitBreakerConfig.access$502(config, this.recordExceptions);
            CircuitBreakerConfig.access$402(config, this.ignoreExceptions);
            config.automaticTransitionFromOpenToHalfOpenEnabled = this.automaticTransitionFromOpenToHalfOpenEnabled;
            config.recordFailurePredicate = this.createRecordFailurePredicate();
            return config;
        }

        private Predicate<Throwable> createRecordFailurePredicate() {
            return this.createRecordExceptionPredicate().and(PredicateCreator.createIgnoreExceptionsPredicate((Class[])this.ignoreExceptions).orElse(DEFAULT_RECORD_FAILURE_PREDICATE));
        }

        private Predicate<Throwable> createRecordExceptionPredicate() {
            return PredicateCreator.createRecordExceptionsPredicate((Class[])this.recordExceptions).map(predicate -> this.recordFailurePredicate != null ? predicate.or(this.recordFailurePredicate) : predicate).orElseGet(() -> this.recordFailurePredicate != null ? this.recordFailurePredicate : DEFAULT_RECORD_FAILURE_PREDICATE);
        }
    }
}

