/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Objects;
import java.util.function.Supplier;

public class Utils {
    public static <T> T runWithNullContextClassLoader(Supplier<T> supplier) {
        return Utils.runWithGivenClassLoader(supplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithGivenClassLoader(Supplier<T> supplier, ClassLoader classLoader) {
        Objects.requireNonNull(supplier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

