/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.opennms.core.rpc.utils.mate.EmptyScope;
import org.opennms.core.rpc.utils.mate.EntityScopeProvider;
import org.opennms.core.rpc.utils.mate.FallbackScope;
import org.opennms.core.rpc.utils.mate.Scope;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ExpressionThresholdValue;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdDefVisitor;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRearmingAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThresholdEntity
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdEntity.class);
    private static List<ThresholdEvaluator> s_thresholdEvaluators = new LinkedList<ThresholdEvaluator>();
    private Map<String, List<ThresholdEvaluatorState>> m_thresholdEvaluatorStates = new HashMap<String, List<ThresholdEvaluatorState>>();
    private ThresholdingEventProxy m_thresholdingEventProxy;
    private final EntityScopeProvider m_entityScopeProvider;

    public ThresholdEntity(EntityScopeProvider entityScopeProvider) {
        this.m_thresholdEvaluatorStates.put(null, new LinkedList());
        this.m_entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public BaseThresholdDefConfigWrapper getThresholdConfig() {
        return this.m_thresholdEvaluatorStates.get(null).get(0).getThresholdConfig();
    }

    private boolean hasThresholds() {
        return this.m_thresholdEvaluatorStates.get(null).size() != 0;
    }

    public String getDataSourceExpression() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDatasourceExpression();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceType() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsType();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceLabel() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsLabel().orElse(null);
        }
        return null;
    }

    public Collection<String> getRequiredDatasources() {
        if (this.hasThresholds()) {
            HashSet<String> dataSources = new HashSet<String>();
            dataSources.addAll(this.getThresholdConfig().getRequiredDatasources());
            dataSources.addAll(this.getThresholdConfig().getFilterDatasources());
            return dataSources;
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public ThresholdEntity clone() {
        ThresholdEntity clone = new ThresholdEntity(this.m_entityScopeProvider);
        for (ThresholdEvaluatorState thresholdItem : this.getThresholdEvaluatorStates(null)) {
            clone.addThreshold(thresholdItem.getThresholdConfig(), thresholdItem.getThresholdingSession());
        }
        return clone;
    }

    public String toString() {
        if (!this.hasThresholds()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("evaluator=").append(this.getThresholdConfig().getType());
        buffer.append(", dsName=").append(this.getDataSourceExpression());
        buffer.append(", dsType=").append(this.getDatasourceType());
        buffer.append(", evaluators=[");
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(null)) {
            buffer.append("{ds=").append(item.getThresholdConfig().getDatasourceExpression());
            buffer.append(", value=").append(item.getThresholdConfig().getValue());
            buffer.append(", rearm=").append(item.getThresholdConfig().getRearm());
            buffer.append(", trigger=").append(item.getThresholdConfig().getTrigger());
            buffer.append("}");
        }
        buffer.append("]}");
        return buffer.toString();
    }

    public List<Event> evaluateAndCreateEvents(Map<String, Double> values, Date date) {
        return this.evaluateAndCreateEvents(null, values, date);
    }

    public List<Event> evaluateAndCreateEvents(final CollectionResourceWrapper resource, final Map<String, Double> values, Date date) {
        LinkedList<Event> events = new LinkedList<Event>();
        String instance = null;
        if (resource != null) {
            instance = resource.getInstanceLabel();
        }
        if (this.getThresholdEvaluatorStates(instance).isEmpty()) {
            throw new IllegalStateException("No thresholds have been added.");
        }
        final AtomicReference<Object> evaluateFunctionRef = new AtomicReference<Object>(null);
        this.getThresholdConfig().accept(new ThresholdDefVisitor(){

            @Override
            public void visit(ThresholdConfigWrapper thresholdConfigWrapper) {
                double computedValue = thresholdConfigWrapper.evaluate(values);
                evaluateFunctionRef.set(item -> new ThresholdEvaluatorState.ValueStatus(computedValue, item.evaluate(computedValue, resource == null ? null : resource.getSequenceNumber())));
            }

            @Override
            public void visit(final ExpressionConfigWrapper expressionConfigWrapper) {
                ExpressionThresholdValue expressionThresholdValue = new ExpressionThresholdValue(){

                    @Override
                    public double get(Consumer<String> expressionConsumer) throws ThresholdExpressionException {
                        Scope[] scopes = new Scope[]{EmptyScope.EMPTY, EmptyScope.EMPTY, EmptyScope.EMPTY};
                        if (resource != null) {
                            scopes[0] = ThresholdEntity.this.m_entityScopeProvider.getScopeForNode(Integer.valueOf(resource.getNodeId()));
                            String interfaceIp = resource.getHostAddress();
                            if (interfaceIp != null) {
                                scopes[1] = ThresholdEntity.this.m_entityScopeProvider.getScopeForInterface(Integer.valueOf(resource.getNodeId()), interfaceIp);
                                scopes[2] = ThresholdEntity.this.m_entityScopeProvider.getScopeForService(Integer.valueOf(resource.getNodeId()), InetAddresses.forString((String)interfaceIp), resource.getServiceName());
                            }
                        }
                        FallbackScope fallbackScope = new FallbackScope(scopes);
                        ExpressionConfigWrapper.ExpressionValue expressionValue = expressionConfigWrapper.interpolateAndEvaluate(values, (Scope)fallbackScope);
                        expressionConsumer.accept(expressionValue.expression);
                        return expressionValue.value;
                    }

                    @Override
                    public double get(String evaluatedExpression) throws ThresholdExpressionException {
                        return expressionConfigWrapper.evaluate(evaluatedExpression, values);
                    }
                };
                evaluateFunctionRef.set(item -> item.evaluate(expressionThresholdValue, resource == null ? null : resource.getSequenceNumber()));
            }
        });
        EvaluateFunction evaluateFunction = evaluateFunctionRef.get();
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(instance)) {
            ThresholdEvaluatorState.ValueStatus result;
            try {
                result = evaluateFunction.evaluate(item);
            }
            catch (ThresholdExpressionException e) {
                LOG.warn("Error evaluating: threshold: {} and evaluator: {}", new Object[]{this, item, e});
                continue;
            }
            ThresholdEvaluatorState.Status status = result.status;
            Event event = item.getEventForState(status, date, result.value, resource);
            LOG.debug("evaluated: value= {} against threshold: {} and evaluator: {}", new Object[]{result.value, this, item});
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    public void addThreshold(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        ThresholdEvaluator evaluator = this.getEvaluatorForThreshold(threshold);
        List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
        for (ThresholdEvaluatorState item : defaultList) {
            if (!threshold.getType().equals((Object)item.getThresholdConfig().getType())) continue;
            throw new IllegalStateException(threshold.getType() + " threshold already set.");
        }
        defaultList.add(evaluator.getThresholdEvaluatorState(threshold, thresholdingSession));
    }

    private ThresholdEvaluator getEvaluatorForThreshold(BaseThresholdDefConfigWrapper threshold) {
        for (ThresholdEvaluator evaluator : ThresholdEntity.getThresholdEvaluators()) {
            if (!evaluator.supportsType(threshold.getType())) continue;
            return evaluator;
        }
        String message = "Threshold type '" + threshold.getType() + "' for " + threshold.getDatasourceExpression() + " is not supported";
        LOG.warn(message);
        throw new IllegalArgumentException(message);
    }

    public List<ThresholdEvaluatorState> getThresholdEvaluatorStates(String instance) {
        List<ThresholdEvaluatorState> result = this.m_thresholdEvaluatorStates.get(instance);
        if (result == null) {
            List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
            result = new LinkedList<ThresholdEvaluatorState>();
            for (ThresholdEvaluatorState state : defaultList) {
                result.add(state.getCleanClone());
            }
            this.m_thresholdEvaluatorStates.put(instance == null ? null : instance.intern(), result);
        }
        return result;
    }

    public void merge(ThresholdEntity entity) {
        if (!this.getThresholdConfig().equals(entity.getThresholdConfig())) {
            this.sendRearmForTriggeredStates();
            this.getThresholdConfig().merge(entity.getThresholdConfig());
        }
    }

    public void delete() {
        this.sendRearmForTriggeredStates();
    }

    private void sendRearmForTriggeredStates() {
        for (String instance : this.m_thresholdEvaluatorStates.keySet()) {
            for (ThresholdEvaluatorState state : this.m_thresholdEvaluatorStates.get(instance)) {
                if (!state.isTriggered()) continue;
                Event e = state.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), Double.NaN, null);
                Parm p = new Parm();
                p.setParmName("reason");
                Value v = new Value();
                v.setContent("Configuration has been changed");
                p.setValue(v);
                e.addParm(p);
                LOG.info("sendRearmForTriggeredStates: sending rearm for {}", (Object)e);
                this.m_thresholdingEventProxy.sendEvent(e);
                state.clearState();
            }
        }
    }

    public static final List<ThresholdEvaluator> getThresholdEvaluators() {
        return s_thresholdEvaluators;
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.m_thresholdingEventProxy = eventProxy;
    }

    static {
        s_thresholdEvaluators.add(new ThresholdEvaluatorHighLow());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRelativeChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorAbsoluteChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRearmingAbsoluteChange());
    }

    @FunctionalInterface
    private static interface EvaluateFunction {
        public ThresholdEvaluatorState.ValueStatus evaluate(ThresholdEvaluatorState var1) throws ThresholdExpressionException;
    }
}

