/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.opennms.netmgt.telemetry.api.receiver.Dispatchable;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpListener.class);
    private final String name;
    private final List<UdpParser> parsers;
    private final Meter packetsReceived;
    private EventLoopGroup bossGroup;
    private ChannelFuture socketFuture;
    private String host = null;
    private int port = 50000;
    private int maxPacketSize = 8096;

    public UdpListener(String name, List<UdpParser> parsers, MetricRegistry metrics) {
        this.name = Objects.requireNonNull(name);
        this.parsers = Objects.requireNonNull(parsers);
        Objects.requireNonNull(metrics);
        if (this.parsers.isEmpty()) {
            throw new IllegalArgumentException("At least 1 parsers must be defined");
        }
        if (this.parsers.size() > 1 && this.parsers.stream().filter(p -> p instanceof Dispatchable).count() != (long)this.parsers.size()) {
            throw new IllegalArgumentException("If more than 1 parser is defined, all parsers must be Dispatchable");
        }
        this.packetsReceived = metrics.meter(MetricRegistry.name((String)"listeners", (String[])new String[]{name, "packetsReceived"}));
    }

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("telemetryd-nio-" + this.name + "-%d").build());
        this.parsers.forEach(parser -> parser.start((ScheduledExecutorService)this.bossGroup));
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        this.socketFuture = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.bossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)Integer.MAX_VALUE)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.maxPacketSize))).handler((ChannelHandler)new DefaultChannelInitializer())).bind((SocketAddress)address).sync();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        this.socketFuture.channel().close().sync();
        this.parsers.forEach(Parser::stop);
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public String getName() {
        return this.name;
    }

    private static class SingleDatagramPacketParserHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        final UdpParser parser;

        private SingleDatagramPacketParserHandler(UdpParser parser) {
            this.parser = parser;
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
            this.parser.parse(((ByteBuf)ReferenceCountUtil.retain((Object)msg.content())).nioBuffer(), (InetSocketAddress)msg.sender(), (InetSocketAddress)msg.recipient()).handle((result, ex) -> {
                ReferenceCountUtil.release((Object)msg.content());
                if (ex != null) {
                    ctx.fireExceptionCaught(ex);
                }
                return result;
            });
        }
    }

    private class AccountingHandler
    extends ChannelInboundHandlerAdapter {
        private AccountingHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            UdpListener.this.packetsReceived.mark();
            super.channelRead(ctx, msg);
        }
    }

    private class DefaultChannelInitializer
    extends ChannelInitializer<DatagramChannel> {
        private DefaultChannelInitializer() {
        }

        protected void initChannel(DatagramChannel ch) {
            if (UdpListener.this.parsers.size() == 1) {
                UdpParser parser = (UdpParser)UdpListener.this.parsers.get(0);
                ch.pipeline().addLast(new ChannelHandler[]{new SingleDatagramPacketParserHandler(parser)});
            } else {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

                    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                        for (UdpParser parser : UdpListener.this.parsers) {
                            if (!((Boolean)BufferUtils.peek((ByteBuffer)((ByteBuf)msg.content()).nioBuffer(), arg_0 -> ((Dispatchable)((Dispatchable)parser)).handles(arg_0))).booleanValue()) continue;
                            new SingleDatagramPacketParserHandler(parser).channelRead0(ctx, msg);
                            return;
                        }
                        LOG.warn("Unhandled packet from {}", (Object)msg.sender());
                    }
                }});
            }
            ch.pipeline().addFirst(new ChannelHandler[]{new AccountingHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    LOG.warn("Invalid packet: {}", (Object)cause.getMessage());
                    LOG.debug("", cause);
                }
            }});
        }
    }
}

