/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.common;

import java.util.Objects;
import org.opennms.features.distributed.coordination.api.Role;
import org.opennms.integration.api.v1.coordination.DomainManager;
import org.opennms.integration.api.v1.coordination.DomainManagerFactory;
import org.opennms.integration.api.v1.coordination.RoleChangeHandler;

public class OICompatibleDomainManagerFactory
implements DomainManagerFactory {
    private final org.opennms.features.distributed.coordination.api.DomainManagerFactory delegate;

    public OICompatibleDomainManagerFactory(org.opennms.features.distributed.coordination.api.DomainManagerFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public DomainManager getManagerForDomain(String domain) {
        final org.opennms.features.distributed.coordination.api.DomainManager domainManager = this.delegate.getManagerForDomain(domain);
        if (domainManager == null) {
            return null;
        }
        return new DomainManager(){

            public void register(String id, final RoleChangeHandler roleChangeHandler) {
                domainManager.register(id, new org.opennms.features.distributed.coordination.api.RoleChangeHandler(){

                    public void handleRoleChange(Role role, String domain) {
                        roleChangeHandler.handleRoleChange(OICompatibleDomainManagerFactory.toRole(role), domain);
                    }
                });
            }

            public void deregister(String id) {
                domainManager.deregister(id);
            }

            public boolean isRegistered(String id) {
                return domainManager.isRegistered(id);
            }

            public boolean isAnythingRegistered() {
                return domainManager.isAnythingRegistered();
            }
        };
    }

    private static org.opennms.integration.api.v1.coordination.Role toRole(Role role) {
        if (role == null) {
            return null;
        }
        switch (role) {
            case ACTIVE: {
                return org.opennms.integration.api.v1.coordination.Role.ACTIVE;
            }
            case STANDBY: {
                return org.opennms.integration.api.v1.coordination.Role.STANDBY;
            }
        }
        return org.opennms.integration.api.v1.coordination.Role.UNKNOWN;
    }
}

